/*
 * Decompiled with CFR 0.152.
 */
package dev.robocode.tankroyale.botapi.internal;

import dev.robocode.tankroyale.botapi.events.BotEvent;
import dev.robocode.tankroyale.botapi.events.Condition;
import dev.robocode.tankroyale.botapi.events.CustomEvent;
import dev.robocode.tankroyale.botapi.events.TickEvent;
import dev.robocode.tankroyale.botapi.internal.BaseBotInternals;
import dev.robocode.tankroyale.botapi.internal.BotEventHandlers;
import dev.robocode.tankroyale.botapi.internal.EventInterruption;
import dev.robocode.tankroyale.botapi.internal.EventPriorities;
import dev.robocode.tankroyale.botapi.internal.ThreadInterruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

final class EventQueue {
    private static final int MAX_QUEUE_SIZE = 256;
    private static final int MAX_EVENT_AGE = 2;
    private final BaseBotInternals baseBotInternals;
    private final BotEventHandlers botEventHandlers;
    private final List<BotEvent> events = Collections.synchronizedList(new ArrayList());
    private BotEvent currentTopEvent;
    private int currentTopEventPriority;

    public EventQueue(BaseBotInternals baseBotInternals, BotEventHandlers botEventHandlers) {
        this.baseBotInternals = baseBotInternals;
        this.botEventHandlers = botEventHandlers;
    }

    void clear() {
        this.clearEvents();
        this.baseBotInternals.getConditions().clear();
        this.currentTopEventPriority = Integer.MIN_VALUE;
    }

    List<BotEvent> getEvents(int turnNumber) {
        this.removeOldEvents(turnNumber);
        return new ArrayList<BotEvent>(this.events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearEvents() {
        List<BotEvent> list = this.events;
        synchronized (list) {
            this.events.clear();
        }
    }

    void setCurrentEventInterruptible(boolean interruptible) {
        EventInterruption.setInterruptible(this.currentTopEvent.getClass(), interruptible);
    }

    private boolean isCurrentEventInterruptible() {
        return EventInterruption.isInterruptible(this.currentTopEvent.getClass());
    }

    void addEventsFromTick(TickEvent event) {
        this.addEvent(event);
        event.getEvents().forEach(this::addEvent);
    }

    void dispatchEvents(int turnNumber) {
        BotEvent currentEvent;
        this.removeOldEvents(turnNumber);
        this.addCustomEvents();
        this.sortEvents();
        while (this.isBotRunning() && (currentEvent = this.peekNextEvent()) != null && this.getPriority(currentEvent) >= this.currentTopEventPriority) {
            if (this.getPriority(currentEvent) == this.currentTopEventPriority) {
                if (this.currentTopEventPriority <= Integer.MIN_VALUE || !this.isCurrentEventInterruptible()) break;
                EventInterruption.setInterruptible(this.currentTopEvent.getClass(), false);
                throw new ThreadInterruptedException();
            }
            int oldTopEventPriority = this.currentTopEventPriority;
            this.currentTopEventPriority = this.getPriority(currentEvent);
            this.currentTopEvent = currentEvent;
            this.removeNextEvent();
            try {
                this.dispatch(currentEvent, turnNumber);
            }
            catch (ThreadInterruptedException ignore) {
                this.currentTopEvent = null;
            }
            catch (Error | RuntimeException e) {
                this.currentTopEvent = null;
                throw e;
            }
            finally {
                this.currentTopEventPriority = oldTopEventPriority;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldEvents(int turnNumber) {
        List<BotEvent> list = this.events;
        synchronized (list) {
            this.events.removeIf(event -> EventQueue.isOldAndNonCriticalEvent(event, turnNumber));
        }
    }

    private void sortEvents() {
        this.events.sort((botEvent1, botEvent2) -> {
            int diff = (botEvent2.isCritical() ? 1 : 0) - (botEvent1.isCritical() ? 1 : 0);
            if (diff != 0) {
                return diff;
            }
            diff = botEvent1.getTurnNumber() - botEvent2.getTurnNumber();
            if (diff != 0) {
                return diff;
            }
            return this.getPriority((BotEvent)botEvent2) - this.getPriority((BotEvent)botEvent1);
        });
    }

    private boolean isBotRunning() {
        return this.baseBotInternals.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BotEvent peekNextEvent() {
        List<BotEvent> list = this.events;
        synchronized (list) {
            return this.events.isEmpty() ? null : this.events.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNextEvent() {
        List<BotEvent> list = this.events;
        synchronized (list) {
            if (!this.events.isEmpty()) {
                this.events.remove(0);
            }
        }
    }

    private int getPriority(BotEvent botEvent) {
        Class<?> eventClass = botEvent.getClass();
        return EventPriorities.getPriority(eventClass);
    }

    private void dispatch(BotEvent botEvent, int turnNumber) {
        try {
            if (EventQueue.isNotOldOrIsCriticalEvent(botEvent, turnNumber)) {
                this.botEventHandlers.fireEvent(botEvent);
            }
        }
        finally {
            EventInterruption.setInterruptible(botEvent.getClass(), false);
        }
    }

    private static boolean isNotOldOrIsCriticalEvent(BotEvent botEvent, int turnNumber) {
        boolean isNotOld = botEvent.getTurnNumber() >= turnNumber - 2;
        return isNotOld || botEvent.isCritical();
    }

    private static boolean isOldAndNonCriticalEvent(BotEvent botEvent, int turnNumber) {
        boolean isOld = botEvent.getTurnNumber() < turnNumber - 2;
        return isOld && !botEvent.isCritical();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(BotEvent botEvent) {
        List<BotEvent> list = this.events;
        synchronized (list) {
            if (this.events.size() <= 256) {
                this.events.add(botEvent);
            } else {
                System.err.println("Maximum event queue size has been reached: 256");
            }
        }
    }

    private void addCustomEvents() {
        this.baseBotInternals.getConditions().stream().filter(Condition::test).forEach(condition -> this.addEvent(new CustomEvent(this.baseBotInternals.getCurrentTickOrThrow().getTurnNumber(), (Condition)condition)));
    }

    private void dumpEvents(int turnNumber) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        this.events.forEach(event -> stringJoiner.add(event.getClass().getSimpleName() + "(" + event.getTurnNumber() + ")"));
        System.out.println(turnNumber + " events: " + String.valueOf(stringJoiner));
    }
}

