/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.MethodResolver;
import dev.runabout.MethodResolverImpl;
import dev.runabout.RunaboutApi;
import dev.runabout.RunaboutListener;
import dev.runabout.RunaboutSerializer;
import dev.runabout.RunaboutService;
import dev.runabout.RunaboutServiceImpl;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;

public class RunaboutServiceBuilder {
    private MethodResolver methodResolver;
    private RunaboutSerializer customSerializer;
    private RunaboutListener listener;
    private RunaboutApi runaboutApi;
    private final String projectName;

    public RunaboutServiceBuilder(String projectName) {
        this.projectName = Objects.requireNonNull(projectName, "Runabout project name is required.");
    }

    public RunaboutServiceBuilder setRunaboutApi(RunaboutApi runaboutApi) {
        this.runaboutApi = runaboutApi;
        return this;
    }

    public RunaboutServiceBuilder setMethodResolver(MethodResolver methodResolver) {
        this.methodResolver = Objects.requireNonNull(methodResolver, "Caller supplier cannot be null.");
        return this;
    }

    public RunaboutServiceBuilder setCustomSerializer(RunaboutSerializer customSerializer) {
        this.customSerializer = Objects.requireNonNull(customSerializer, "Custom serializer cannot be null.");
        return this;
    }

    public RunaboutServiceBuilder setListener(RunaboutListener listener) {
        this.listener = listener;
        return this;
    }

    public RunaboutService build() {
        RunaboutApi runaboutApiFinal = RunaboutServiceBuilder.resolveService(this.runaboutApi, RunaboutApi.class).orElseThrow(() -> new IllegalArgumentException("Runabout API is required."));
        MethodResolver methodResolverFinal = RunaboutServiceBuilder.resolveService(this.methodResolver, MethodResolver.class).orElseGet(MethodResolverImpl::new);
        RunaboutSerializer customSerializerFinal = RunaboutServiceBuilder.resolveService(this.customSerializer, RunaboutSerializer.class).orElse(null);
        RunaboutListener listenerFinal = RunaboutServiceBuilder.resolveService(this.listener, RunaboutListener.class).orElse(null);
        return new RunaboutServiceImpl(this.projectName, runaboutApiFinal, methodResolverFinal, listenerFinal, customSerializerFinal);
    }

    private static <T> Optional<T> resolveService(T input, Class<T> service) {
        return Optional.ofNullable(input).or(() -> ServiceLoader.load(service).findFirst());
    }
}

