/*
 * Decompiled with CFR 0.152.
 */
package dev.runabout;

import dev.runabout.DefaultSerializer;
import dev.runabout.JsonObject;
import dev.runabout.MethodResolver;
import dev.runabout.RunaboutApi;
import dev.runabout.RunaboutInput;
import dev.runabout.RunaboutInstance;
import dev.runabout.RunaboutListener;
import dev.runabout.RunaboutScenario;
import dev.runabout.RunaboutSerializer;
import dev.runabout.RunaboutService;
import dev.runabout.annotations.Nullable;
import dev.runabout.annotations.RunaboutEnabled;
import dev.runabout.annotations.RunaboutParameter;
import dev.runabout.annotations.ToRunabout;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

class RunaboutServiceImpl
implements RunaboutService {
    private final String projectName;
    private final RunaboutApi runaboutApi;
    private final MethodResolver methodResolver;
    private final RunaboutListener listener;
    private final RunaboutSerializer customSerializer;
    private final DefaultSerializer defaultSerializer = DefaultSerializer.getInstance();

    RunaboutServiceImpl(String projectName, RunaboutApi runaboutApi, MethodResolver methodResolver, RunaboutListener listener, RunaboutSerializer customSerializer) {
        this.projectName = projectName;
        this.methodResolver = methodResolver;
        this.customSerializer = customSerializer;
        this.runaboutApi = runaboutApi;
        this.listener = listener;
    }

    @Override
    public RunaboutInput serialize(Object object) {
        if (object == null) {
            return DefaultSerializer.getNullInput();
        }
        RunaboutInput input = this.invokeInstanceSerializer(object);
        if (input == null) {
            input = this.invokeSafe(this.customSerializer, object);
        }
        if (input == null) {
            input = this.invokeSafe((Object o) -> this.defaultSerializer.toRunaboutGenericRecursive(o, this::serialize), object);
        }
        return Optional.ofNullable(input).orElseGet(DefaultSerializer::getEmptyInput);
    }

    @Override
    public RunaboutScenario createScenario(String eventId, JsonObject properties, Object ... objects) {
        Timestamp datetime = RunaboutServiceImpl.getDatetime();
        String method = this.methodResolver.getSerializedMethod();
        ArrayList<RunaboutInstance> instances = new ArrayList<RunaboutInstance>();
        for (Object object : objects) {
            RunaboutInput input = this.serialize(object);
            String type = RunaboutServiceImpl.getTypeSafe(object);
            RunaboutInstance instance = RunaboutInstance.of(type, input);
            instances.add(instance);
        }
        return new RunaboutScenario(method, eventId, this.projectName, datetime, properties, instances);
    }

    @Override
    public void saveScenario(String eventId, JsonObject properties, Object ... objects) {
        RunaboutScenario scenario = this.createScenario(eventId, properties, objects);
        this.runaboutApi.ingestScenario(scenario);
    }

    private RunaboutInput invokeInstanceSerializer(Object object) {
        Class<?> clazz = object.getClass();
        RunaboutInput input = this.invokeRunaboutEnabledSerializer(object, clazz);
        if (input == null) {
            input = this.invokeToRunaboutSerializer(object, clazz);
            while (input == null && clazz.getSuperclass() != null) {
                clazz = clazz.getSuperclass();
                input = this.invokeToRunaboutSerializer(object, clazz);
            }
        }
        return input;
    }

    @Nullable
    private RunaboutInput invokeRunaboutEnabledSerializer(Object object, Class<?> clazz) {
        try {
            RunaboutInput input = null;
            Constructor constructor = Arrays.stream(clazz.getConstructors()).filter(c -> c.isAnnotationPresent(RunaboutEnabled.class)).findFirst().orElse(null);
            if (constructor != null) {
                HashMap<String, List> parameterMap = new HashMap<String, List>();
                for (int i = 0; i < constructor.getParameters().length; ++i) {
                    Parameter parameter = constructor.getParameters()[i];
                    if (!parameter.isAnnotationPresent(RunaboutParameter.class)) {
                        throw new RuntimeException("RunaboutEnabled constructor parameters must be annotated with RunaboutParameter. Parameter: [" + parameter.getName() + "] in class: [" + clazz.getCanonicalName() + "] is not annotated.");
                    }
                    parameterMap.computeIfAbsent(parameter.getAnnotation(RunaboutParameter.class).value(), v -> new ArrayList()).add(i);
                }
                ArrayList fields = new ArrayList(parameterMap.size());
                Arrays.stream(clazz.getDeclaredFields()).takeWhile(f -> !parameterMap.isEmpty()).forEach(f -> {
                    List indices = (List)parameterMap.remove(f.getName());
                    if (indices != null) {
                        indices.forEach(index -> fields.add((int)index, f));
                    }
                });
                if (parameterMap.isEmpty()) {
                    StringJoiner joiner = new StringJoiner(", ");
                    HashSet<String> dependencies = new HashSet<String>(Set.of(clazz.getCanonicalName()));
                    for (Field field : fields) {
                        field.setAccessible(true);
                        Object value = field.get(object);
                        RunaboutInput fieldInput = this.serialize(value);
                        if (fieldInput == null || fieldInput.getEval() == null || fieldInput.getEval().isEmpty()) {
                            fieldInput = DefaultSerializer.getNullInput();
                        }
                        joiner.add(fieldInput.getEval());
                        dependencies.addAll(fieldInput.getDependencies());
                    }
                    String eval = "new " + clazz.getSimpleName() + "(" + joiner + ")";
                    input = RunaboutInput.of(eval, dependencies);
                }
            }
            return input;
        }
        catch (Throwable t) {
            this.listener.onError(t);
            return null;
        }
    }

    @Nullable
    private RunaboutInput invokeToRunaboutSerializer(Object object, Class<?> clazz) {
        Set methods = Optional.ofNullable(clazz).map(cls -> {
            HashSet<Method> set = new HashSet<Method>(Set.of(cls.getMethods()));
            set.addAll(Set.of(cls.getDeclaredMethods()));
            return set;
        }).orElseGet(Collections::emptySet);
        return methods.stream().filter(method -> method.isAnnotationPresent(ToRunabout.class)).findFirst().map(method -> this.invokeSafe((Method)method, object)).orElse(null);
    }

    private RunaboutInput invokeSafe(Method method, Object object) {
        RunaboutInput input = null;
        try {
            method.setAccessible(true);
            RunaboutInput tempInput = (RunaboutInput)method.invoke(object, new Object[0]);
            if (RunaboutServiceImpl.validInput(tempInput)) {
                input = tempInput;
            }
        }
        catch (InvocationTargetException e) {
            this.listener.onError(e.getCause() != null ? e.getCause() : e);
        }
        catch (Throwable t) {
            this.listener.onError(t);
        }
        return input;
    }

    private RunaboutInput invokeSafe(RunaboutSerializer serializer, Object o) {
        RunaboutInput input = null;
        if (serializer != null) {
            try {
                RunaboutInput tempInput = serializer.toRunaboutGeneric(o);
                if (RunaboutServiceImpl.validInput(tempInput)) {
                    input = tempInput;
                }
            }
            catch (Throwable ex) {
                this.listener.onError(ex);
            }
        }
        return input;
    }

    private static boolean validInput(RunaboutInput input) {
        return input != null && input.getEval() != null && !input.getEval().isEmpty() && input.getDependencies() != null;
    }

    private static String getTypeSafe(Object object) {
        return Optional.ofNullable(object).map(Object::getClass).map(clazz -> clazz.isAnonymousClass() ? RunaboutServiceImpl.getAnonymousImplClass(clazz) : clazz.getCanonicalName()).orElse("null");
    }

    private static String getAnonymousImplClass(Class<?> clazz) {
        return Optional.ofNullable(clazz).map(c -> c.getInterfaces().length > 0 ? c.getInterfaces()[0] : c.getSuperclass()).map(Class::getCanonicalName).orElse("null");
    }

    private static Timestamp getDatetime() {
        return Timestamp.from(Instant.now());
    }
}

