/*
 * Decompiled with CFR 0.152.
 */
package dev.secondsun.util;

import dev.secondsun.geometry.Texture;
import dev.secondsun.geometry.Vertex2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;

public class Resources
implements Externalizable {
    private final Map<Integer, BufferedImage> images = new HashMap<Integer, BufferedImage>();
    private final Map<Integer, Texture> textures = new HashMap<Integer, Texture>();

    public Map<Integer, BufferedImage> images() {
        return new HashMap<Integer, BufferedImage>(this.images);
    }

    public Map<Integer, Texture> textures() {
        return new HashMap<Integer, Texture>(this.textures);
    }

    public int setImage(BufferedImage in) {
        int hash = in.hashCode();
        this.images.put(hash, in);
        return hash;
    }

    public BufferedImage getImage(int in) {
        return this.images.get(in);
    }

    public int setTexture(int imageId, Vertex2D textureOrigin, int u, int v) {
        Texture text = new Texture(imageId, textureOrigin, u, v);
        int hash = text.hashCode();
        this.textures.put(hash, text);
        return hash;
    }

    public Texture getTexture(int in) {
        return this.textures.get(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.images.size());
        this.images.entrySet().forEach(entry -> {
            try {
                out.writeInt((Integer)entry.getKey());
                BufferedImage image = (BufferedImage)entry.getValue();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "PNG", bos);
                out.writeInt(bos.size());
                out.write(bos.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        out.writeInt(this.textures.size());
        this.textures.entrySet().forEach(entry -> {
            try {
                out.writeInt((Integer)entry.getKey());
                out.writeObject(entry.getValue());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int imagesCount = in.readInt();
        IntStream.range(0, imagesCount).forEach(ignore -> {
            try {
                int id = in.readInt();
                int imageLength = in.readInt();
                byte[] imageBytes = new byte[imageLength];
                in.readFully(imageBytes);
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageBytes));
                this.images.put(id, image);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        int textureCount = in.readInt();
        IntStream.range(0, textureCount).forEach(ignore -> {
            try {
                int id = in.readInt();
                Texture texture = (Texture)in.readObject();
                this.textures.put(id, texture);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.images == null ? 0 : this.images.hashCode());
        result = 31 * result + (this.textures == null ? 0 : this.textures.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resources other = (Resources)obj;
        if (this.images == null ? other.images != null : !this.images.equals(other.images)) {
            return false;
        }
        return !(this.textures == null ? other.textures != null : !this.textures.equals(other.textures));
    }
}

