/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.buffer;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.buffer.ApiBufferKey;
import dev.shortloop.agent.buffer.Buffer;
import dev.shortloop.common.models.data.APISample;
import dev.shortloop.common.models.data.AgentConfig;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public abstract class BufferManagerWorker<K> {
    private final ScheduledExecutorService bufferSyncExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new CustomizableThreadFactory("buffer-"));
    protected final ConcurrentMap<ApiBufferKey, Buffer> bufferMap = new ConcurrentHashMap<ApiBufferKey, Buffer>();
    private final AgentConfig config;
    private final String ctUrl;
    protected final SDKLogger logger;

    abstract boolean init();

    abstract boolean offer(K var1, APISample var2);

    abstract boolean canOffer(K var1);

    public AgentConfig getOperatingConfig() {
        return this.config;
    }

    public BufferManagerWorker(@NonNull AgentConfig config, String ctUrl, SDKLogger logger) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.ctUrl = ctUrl;
        this.logger = logger;
        Runnable runnable = this::syncForKeys;
        this.bufferSyncExecutorService.scheduleWithFixedDelay(runnable, config.getBufferSyncFreqInSec().intValue(), config.getBufferSyncFreqInSec().intValue(), TimeUnit.SECONDS);
    }

    public BufferManagerWorker(SDKLogger logger) {
        this.config = null;
        this.ctUrl = null;
        this.logger = logger;
    }

    public abstract boolean offer(ApiBufferKey var1, APISample var2);

    public abstract boolean canOffer(ApiBufferKey var1);

    public boolean shutdown() {
        this.logger.info("Shutting down ApiSampleBufferManagerWorker");
        if (this.bufferSyncExecutorService.isShutdown()) {
            this.cleanUpBufferMap();
            return true;
        }
        try {
            this.bufferSyncExecutorService.shutdown();
            if (!this.bufferSyncExecutorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.bufferSyncExecutorService.shutdownNow();
                if (!this.bufferSyncExecutorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.logger.error("Still not able to shutdown ApiSampleBufferManagerWorker's bufferSyncExecutorService");
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Error while shutting down ApiSampleBufferManagerWorker's bufferSyncExecutorService", e);
        }
        this.cleanUpBufferMap();
        return this.bufferSyncExecutorService.isShutdown();
    }

    private void cleanUpBufferMap() {
        this.syncForKeys();
        for (ApiBufferKey key : this.bufferMap.keySet()) {
            Buffer buffer = (Buffer)this.bufferMap.get(key);
            if (null == buffer) continue;
            buffer.clear();
        }
        this.bufferMap.clear();
    }

    private String getUri() {
        return "/data-ingestion/api-sample";
    }

    abstract void syncForKey(ApiBufferKey var1);

    private void syncForKeys() {
        Set keys = this.bufferMap.keySet();
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        keys.forEach(this::syncForKey);
    }
}

