/*
 * Decompiled with CFR 0.152.
 */
package flysql.api.controller.compare;

import flysql.api.dto.compare.CompareRequestDto;
import flysql.api.dto.compare.CompareResponseDto;
import flysql.api.service.DbConnectionConfigLookupService;
import flysql.domain.models.DbConnectionConfig;
import flysql.domain.models.DbType;
import flysql.sqlresultcompare.models.SqlCompareRequest;
import flysql.sqlresultcompare.models.SqlComparisonMetadata;
import flysql.sqlresultcompare.services.SqlResultCompareService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lflysql/api/controller/compare/AbstractCompareController;", "", "lookupService", "Lflysql/api/service/DbConnectionConfigLookupService;", "sqlResultCompareService", "Lflysql/sqlresultcompare/services/SqlResultCompareService;", "dbType", "Lflysql/domain/models/DbType;", "(Lflysql/api/service/DbConnectionConfigLookupService;Lflysql/sqlresultcompare/services/SqlResultCompareService;Lflysql/domain/models/DbType;)V", "compareDbDb", "Lreactor/core/publisher/Mono;", "Lflysql/api/dto/compare/CompareResponseDto;", "reference", "", "candidate", "dto", "Lflysql/api/dto/compare/CompareRequestDto;", "flysql-executor"})
@SourceDebugExtension(value={"SMAP\nAbstractCompareController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCompareController.kt\nflysql/api/controller/compare/AbstractCompareController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public abstract class AbstractCompareController {
    @NotNull
    private final DbConnectionConfigLookupService lookupService;
    @NotNull
    private final SqlResultCompareService sqlResultCompareService;
    @NotNull
    private final DbType dbType;

    public AbstractCompareController(@NotNull DbConnectionConfigLookupService lookupService, @NotNull SqlResultCompareService sqlResultCompareService, @NotNull DbType dbType) {
        Intrinsics.checkNotNullParameter((Object)lookupService, (String)"lookupService");
        Intrinsics.checkNotNullParameter((Object)sqlResultCompareService, (String)"sqlResultCompareService");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        this.lookupService = lookupService;
        this.sqlResultCompareService = sqlResultCompareService;
        this.dbType = dbType;
    }

    @NotNull
    public final Mono<CompareResponseDto> compareDbDb(@NotNull String reference, @NotNull String candidate, @NotNull CompareRequestDto dto) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Mono mono = Mono.defer(() -> AbstractCompareController.compareDbDb$lambda$1(dto, this, candidate, reference));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        return mono;
    }

    private static final Mono compareDbDb$lambda$1(CompareRequestDto $dto, AbstractCompareController this$0, String $candidate, String $reference) {
        Intrinsics.checkNotNullParameter((Object)$dto, (String)"$dto");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$candidate, (String)"$candidate");
        Intrinsics.checkNotNullParameter((Object)$reference, (String)"$reference");
        if (!(((CharSequence)$dto.getIdColumn()).length() > 0)) {
            boolean $i$a$-require-AbstractCompareController$compareDbDb$1$22 = false;
            String $i$a$-require-AbstractCompareController$compareDbDb$1$22 = "idColumn can not be empty";
            throw new IllegalArgumentException($i$a$-require-AbstractCompareController$compareDbDb$1$22.toString());
        }
        DbConnectionConfig candidateDb = this$0.lookupService.findDbByNameAndType($candidate, null);
        DbConnectionConfig referenceDb = this$0.lookupService.findDbByNameAndType($reference, this$0.dbType);
        SqlCompareRequest compareRequest = CompareRequestDto.Companion.create($dto);
        SqlComparisonMetadata result = this$0.sqlResultCompareService.compare(candidateDb, compareRequest, referenceDb);
        return Mono.just((Object)CompareResponseDto.Companion.create(result));
    }
}

