/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.license.config;

import flysql.domain.license.config.LicenseConfig;
import flysql.domain.license.models.License;
import flysql.domain.license.models.LicenseType;
import flysql.domain.license.server.LicenseVerifier;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0012J\b\u0010\r\u001a\u00020\bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lflysql/domain/license/config/LicenseConfig;", "", "licensePath", "", "(Ljava/lang/String;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "noLicense", "Lflysql/domain/license/models/License;", "getLicense", "jsonPath", "Ljava/nio/file/Path;", "sigPath", "license", "Companion", "flysql-executor"})
@SourceDebugExtension(value={"SMAP\nLicenseConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseConfig.kt\nflysql/domain/license/config/LicenseConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public class LicenseConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String licensePath;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final License noLicense;
    @NotNull
    public static final String FILE_NAME_JSON = "license.json.base64";
    @NotNull
    public static final String FILE_NAME_SIGN = "license.sig";

    public LicenseConfig(@Value(value="${license.path}") @NotNull String licensePath) {
        Intrinsics.checkNotNullParameter((Object)licensePath, (String)"licensePath");
        this.licensePath = licensePath;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.noLicense = License.Companion.create(LicenseType.NOLICENSE, "no license provided");
    }

    private License getLicense(Path jsonPath, Path sigPath) {
        return LicenseVerifier.INSTANCE.verifyAndReturnLicense(jsonPath, sigPath);
    }

    @Bean
    @NotNull
    public License license() {
        String[] stringArray = new String[]{FILE_NAME_JSON};
        Path jsonPath = Paths.get(this.licensePath, stringArray);
        String[] stringArray2 = new String[]{FILE_NAME_SIGN};
        Path sigPath = Paths.get(this.licensePath, stringArray2);
        Intrinsics.checkNotNull((Object)jsonPath);
        Intrinsics.checkNotNull((Object)sigPath);
        License license2 = this.getLicense(jsonPath, sigPath);
        if (license2 == null) {
            LicenseConfig it = this;
            boolean bl = false;
            license2 = this.noLicense;
        }
        License license3 = license2;
        this.logger.info((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return license3;
    }
}

