/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.license.server;

import flysql.domain.license.models.License;
import flysql.domain.license.models.LicenseAndBytes;
import flysql.domain.license.models.LicenseType;
import flysql.domain.license.server.LicenseParser;
import flysql.domain.license.server.LicenseVerifier;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lflysql/domain/license/server/LicenseVerifier;", "", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "publicKey", "Ljava/security/interfaces/RSAPublicKey;", "getPublicKey", "()Ljava/security/interfaces/RSAPublicKey;", "publicKey$delegate", "Lkotlin/Lazy;", "sig", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "logAndReturnNoLicense", "Lflysql/domain/license/models/License;", "message", "", "verifyAndReturnLicense", "jsonPath", "Ljava/nio/file/Path;", "sigPath", "flysql-executor"})
public final class LicenseVerifier {
    @NotNull
    public static final LicenseVerifier INSTANCE = new LicenseVerifier();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final Signature sig = Signature.getInstance("SHA256withRSA");
    @NotNull
    private static final Lazy publicKey$delegate = LazyKt.lazy((Function0)((Function0)publicKey.2.INSTANCE));

    private LicenseVerifier() {
    }

    private final RSAPublicKey getPublicKey() {
        Lazy lazy = publicKey$delegate;
        return (RSAPublicKey)lazy.getValue();
    }

    @Nullable
    public final License verifyAndReturnLicense(@NotNull Path jsonPath, @NotNull Path sigPath) {
        License license2;
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter((Object)sigPath, (String)"sigPath");
        if (Files.exists(jsonPath, new LinkOption[0]) && Files.exists(sigPath, new LinkOption[0])) {
            LicenseAndBytes licenseAndBytes = LicenseParser.INSTANCE.parseFromPath(jsonPath);
            if (licenseAndBytes == null) {
                license2 = this.logAndReturnNoLicense("License file parsing failed: " + jsonPath);
            } else {
                Object object;
                String signatureBase64 = Files.readString(sigPath);
                Intrinsics.checkNotNull((Object)signatureBase64);
                byte[] signatureBytes = LicenseParser.INSTANCE.decode(signatureBase64);
                Object object2 = this;
                try {
                    LicenseVerifier $this$verifyAndReturnLicense_u24lambda_u240 = object2;
                    boolean bl = false;
                    sig.initVerify($this$verifyAndReturnLicense_u24lambda_u240.getPublicKey());
                    sig.update(licenseAndBytes.getByteArray());
                    object = Result.constructor-impl((Object)(sig.verify(signatureBytes) ? licenseAndBytes.getLicense() : $this$verifyAndReturnLicense_u24lambda_u240.logAndReturnNoLicense("Signature verification failed for " + jsonPath)));
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Object it = object = throwable;
                    boolean bl = false;
                    INSTANCE.logAndReturnNoLicense("Sign parsing file failed: " + sigPath + ", " + ((Throwable)it).getMessage());
                }
                license2 = (License)(Result.isFailure-impl((Object)object2) ? null : object2);
            }
        } else {
            logger.error((Function0)new /* Unavailable Anonymous Inner Class!! */);
            license2 = null;
        }
        return license2;
    }

    private final License logAndReturnNoLicense(String message) {
        logger.error((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return License.Companion.create(LicenseType.NOLICENSE, "no license provided");
    }
}

