/*
 * Decompiled with CFR 0.152.
 */
package flysql.domain.models;

import flysql.domain.models.DbConnectionConfig;
import flysql.domain.models.DbDriver;
import flysql.domain.models.DbType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\b\u0018\u0000 02\u00020\u0001:\u00010BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0010\u0010&\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJp\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00c6\u0001\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020\u0007J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\u000eH\u00d6\u0001J\u0006\u0010.\u001a\u00020\u0007J\t\u0010/\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011\u00a8\u00061"}, d2={"Lflysql/domain/models/DbConnectionConfig;", "", "dbDriver", "Lflysql/domain/models/DbDriver;", "dbType", "Lflysql/domain/models/DbType;", "name", "", "username", "password", "database", "connectionString", "host", "port", "", "(Lflysql/domain/models/DbDriver;Lflysql/domain/models/DbType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "getConnectionString", "()Ljava/lang/String;", "getDatabase", "getDbDriver", "()Lflysql/domain/models/DbDriver;", "getDbType", "()Lflysql/domain/models/DbType;", "getHost", "getName", "getPassword", "getPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getUsername", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Lflysql/domain/models/DbDriver;Lflysql/domain/models/DbType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Lflysql/domain/models/DbConnectionConfig;", "displayName", "equals", "", "other", "hashCode", "toJdbcUrl", "toString", "Companion", "flysql-executor"})
@SourceDebugExtension(value={"SMAP\nDbConnectionConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbConnectionConfig.kt\nflysql/domain/models/DbConnectionConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class DbConnectionConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DbDriver dbDriver;
    @NotNull
    private final DbType dbType;
    @NotNull
    private final String name;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @Nullable
    private final String database;
    @Nullable
    private final String connectionString;
    @Nullable
    private final String host;
    @Nullable
    private final Integer port;

    public DbConnectionConfig(@NotNull DbDriver dbDriver, @NotNull DbType dbType, @NotNull String name, @NotNull String username, @NotNull String password, @Nullable String database, @Nullable String connectionString, @Nullable String host, @Nullable Integer port) {
        Intrinsics.checkNotNullParameter((Object)dbDriver, (String)"dbDriver");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.dbDriver = dbDriver;
        this.dbType = dbType;
        this.name = name;
        this.username = username;
        this.password = password;
        this.database = database;
        this.connectionString = connectionString;
        this.host = host;
        this.port = port;
    }

    @NotNull
    public final DbDriver getDbDriver() {
        return this.dbDriver;
    }

    @NotNull
    public final DbType getDbType() {
        return this.dbType;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    @Nullable
    public final String getDatabase() {
        return this.database;
    }

    @Nullable
    public final String getConnectionString() {
        return this.connectionString;
    }

    @Nullable
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @NotNull
    public final String toJdbcUrl() {
        Object object;
        block11: {
            String string;
            Object portString;
            block13: {
                Object object2;
                block12: {
                    block10: {
                        if (this.connectionString == null) break block10;
                        object = StringsKt.startsWith$default((String)this.connectionString, (String)"jdbc:", (boolean)false, (int)2, null) ? this.connectionString : "jdbc:" + this.connectionString;
                        break block11;
                    }
                    object2 = this.port;
                    if (object2 == null) break block12;
                    int it = ((Number)object2).intValue();
                    boolean bl = false;
                    String string2 = ":" + this.port;
                    object2 = string2;
                    if (string2 != null) break block13;
                }
                object2 = portString = "";
            }
            if ((string = this.host) == null) {
                string = "";
            }
            String hostString = string;
            String hostPort = hostString + (String)portString;
            switch (WhenMappings.$EnumSwitchMapping$0[this.dbDriver.ordinal()]) {
                case 1: {
                    object = "jdbc:oracle:thin:@" + hostPort + "/" + this.database;
                    break;
                }
                case 2: {
                    object = "jdbc:postgresql://" + hostPort + "/" + this.database;
                    break;
                }
                case 3: {
                    object = "jdbc:mysql://" + hostPort + "/" + this.database;
                    break;
                }
                case 4: {
                    object = "jdbc:sqlserver://" + hostPort + ";databaseName=" + this.database;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return object;
    }

    @NotNull
    public final String displayName() {
        return this.name + "(" + this.database + ")";
    }

    @NotNull
    public final DbDriver component1() {
        return this.dbDriver;
    }

    @NotNull
    public final DbType component2() {
        return this.dbType;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final String component4() {
        return this.username;
    }

    @NotNull
    public final String component5() {
        return this.password;
    }

    @Nullable
    public final String component6() {
        return this.database;
    }

    @Nullable
    public final String component7() {
        return this.connectionString;
    }

    @Nullable
    public final String component8() {
        return this.host;
    }

    @Nullable
    public final Integer component9() {
        return this.port;
    }

    @NotNull
    public final DbConnectionConfig copy(@NotNull DbDriver dbDriver, @NotNull DbType dbType, @NotNull String name, @NotNull String username, @NotNull String password, @Nullable String database, @Nullable String connectionString, @Nullable String host, @Nullable Integer port) {
        Intrinsics.checkNotNullParameter((Object)dbDriver, (String)"dbDriver");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return new DbConnectionConfig(dbDriver, dbType, name, username, password, database, connectionString, host, port);
    }

    public static /* synthetic */ DbConnectionConfig copy$default(DbConnectionConfig dbConnectionConfig, DbDriver dbDriver, DbType dbType, String string, String string2, String string3, String string4, String string5, String string6, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            dbDriver = dbConnectionConfig.dbDriver;
        }
        if ((n2 & 2) != 0) {
            dbType = dbConnectionConfig.dbType;
        }
        if ((n2 & 4) != 0) {
            string = dbConnectionConfig.name;
        }
        if ((n2 & 8) != 0) {
            string2 = dbConnectionConfig.username;
        }
        if ((n2 & 0x10) != 0) {
            string3 = dbConnectionConfig.password;
        }
        if ((n2 & 0x20) != 0) {
            string4 = dbConnectionConfig.database;
        }
        if ((n2 & 0x40) != 0) {
            string5 = dbConnectionConfig.connectionString;
        }
        if ((n2 & 0x80) != 0) {
            string6 = dbConnectionConfig.host;
        }
        if ((n2 & 0x100) != 0) {
            n = dbConnectionConfig.port;
        }
        return dbConnectionConfig.copy(dbDriver, dbType, string, string2, string3, string4, string5, string6, n);
    }

    @NotNull
    public String toString() {
        return "DbConnectionConfig(dbDriver=" + this.dbDriver + ", dbType=" + this.dbType + ", name=" + this.name + ", username=" + this.username + ", password=" + this.password + ", database=" + this.database + ", connectionString=" + this.connectionString + ", host=" + this.host + ", port=" + this.port + ")";
    }

    public int hashCode() {
        int result = this.dbDriver.hashCode();
        result = result * 31 + this.dbType.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.username.hashCode();
        result = result * 31 + this.password.hashCode();
        result = result * 31 + (this.database == null ? 0 : this.database.hashCode());
        result = result * 31 + (this.connectionString == null ? 0 : this.connectionString.hashCode());
        result = result * 31 + (this.host == null ? 0 : this.host.hashCode());
        result = result * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DbConnectionConfig)) {
            return false;
        }
        DbConnectionConfig dbConnectionConfig = (DbConnectionConfig)other;
        if (this.dbDriver != dbConnectionConfig.dbDriver) {
            return false;
        }
        if (this.dbType != dbConnectionConfig.dbType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)dbConnectionConfig.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.username, (Object)dbConnectionConfig.username)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.password, (Object)dbConnectionConfig.password)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.database, (Object)dbConnectionConfig.database)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.connectionString, (Object)dbConnectionConfig.connectionString)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)dbConnectionConfig.host)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.port, (Object)dbConnectionConfig.port);
    }
}

