/*
 * Decompiled with CFR 0.152.
 */
package flysql.sqlresultcompare.services;

import flysql.domain.license.config.LicenseConfig;
import flysql.domain.license.models.restrictions.NumberOfCompareColumnsRestriction;
import flysql.domain.models.DbConnectionConfig;
import flysql.domain.models.SqlQueryResult;
import flysql.domain.service.CompareServiceExecutionDispatcher;
import flysql.sqlresultcompare.models.SqlCompareRequest;
import flysql.sqlresultcompare.models.SqlComparisonMetadata;
import flysql.sqlresultcompare.models.SqlComparisonResult;
import flysql.sqlresultcompare.services.compare.ColumnMetaFactory;
import flysql.sqlresultcompare.services.compare.SqlResultComparisonDispatcher;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lflysql/sqlresultcompare/services/SqlResultCompareService;", "", "executionDispatcher", "Lflysql/domain/service/CompareServiceExecutionDispatcher;", "licenseConfig", "Lflysql/domain/license/config/LicenseConfig;", "(Lflysql/domain/service/CompareServiceExecutionDispatcher;Lflysql/domain/license/config/LicenseConfig;)V", "compare", "Lflysql/sqlresultcompare/models/SqlComparisonMetadata;", "candidateDb", "Lflysql/domain/models/DbConnectionConfig;", "sqlCompareRequest", "Lflysql/sqlresultcompare/models/SqlCompareRequest;", "referenceDb", "flysql-executor"})
public class SqlResultCompareService {
    @NotNull
    private final CompareServiceExecutionDispatcher executionDispatcher;
    @NotNull
    private final LicenseConfig licenseConfig;

    public SqlResultCompareService(@NotNull CompareServiceExecutionDispatcher executionDispatcher, @NotNull LicenseConfig licenseConfig) {
        Intrinsics.checkNotNullParameter((Object)executionDispatcher, (String)"executionDispatcher");
        Intrinsics.checkNotNullParameter((Object)licenseConfig, (String)"licenseConfig");
        this.executionDispatcher = executionDispatcher;
        this.licenseConfig = licenseConfig;
    }

    @NotNull
    public SqlComparisonMetadata compare(@NotNull DbConnectionConfig candidateDb, @NotNull SqlCompareRequest sqlCompareRequest, @NotNull DbConnectionConfig referenceDb) {
        Intrinsics.checkNotNullParameter((Object)candidateDb, (String)"candidateDb");
        Intrinsics.checkNotNullParameter((Object)sqlCompareRequest, (String)"sqlCompareRequest");
        Intrinsics.checkNotNullParameter((Object)referenceDb, (String)"referenceDb");
        Set reducedCompareColumns = (Set)NumberOfCompareColumnsRestriction.INSTANCE.getRestriction().enforce(this.licenseConfig.license().getType(), (Object)sqlCompareRequest.getCompareColumns());
        SqlQueryResult candidateSqlQueryResult = this.executionDispatcher.execute(candidateDb, sqlCompareRequest.getCandidateSql());
        SqlQueryResult referenceSqlQueryResult = this.executionDispatcher.execute(referenceDb, sqlCompareRequest.getReferenceSql());
        Map columnMetaMap = ColumnMetaFactory.INSTANCE.create((Collection)candidateSqlQueryResult.getColumnNames(), (Collection)reducedCompareColumns, sqlCompareRequest.getIdColumn(), (Collection)referenceSqlQueryResult.getColumnNames());
        SqlComparisonResult sqlComparisonResult = SqlResultComparisonDispatcher.INSTANCE.compare(candidateSqlQueryResult, columnMetaMap, sqlCompareRequest.getCompareColumns(), referenceSqlQueryResult);
        return new SqlComparisonMetadata(candidateDb.getName(), candidateSqlQueryResult, sqlCompareRequest.getCandidateSql(), sqlComparisonResult, referenceDb.getName(), referenceSqlQueryResult, sqlCompareRequest.getReferenceSql());
    }
}

