/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.sqlite;

import dev.tuxjsql.basic.sql.BasicSQLColumn;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.sql.SQLColumn;
import dev.tuxjsql.core.sql.SQLDataType;
import dev.tuxjsql.core.sql.SQLTable;
import dev.tuxjsql.sqlite.Queries;
import java.util.List;

public class SQLiteColumn
extends BasicSQLColumn {
    private static final String AUTOINCREMENT = " AUTOINCREMENT";
    private static final String PRIMARY_KEY = " PRIMARY KEY";

    public SQLiteColumn(String name, Object defaultValue, List<String> dataTypeRules, boolean notNull, boolean unique, boolean autoIncrement, boolean primaryKey, SQLColumn foreignKey, SQLTable table, SQLDataType type, TuxJSQL tuxJSQL) {
        super(name, defaultValue, dataTypeRules, notNull, unique, autoIncrement, primaryKey, foreignKey, table, type, tuxJSQL);
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append("`").append(this.name).append("`");
        builder.append(" ").append(this.buildDataType());
        builder.append(this.primaryKey() ? PRIMARY_KEY : "");
        builder.append(this.autoIncrement() ? AUTOINCREMENT : "");
        if (!this.autoIncrement()) {
            builder.append(this.notNull() ? " NOT NULL" : "");
            builder.append(this.unique() ? " UNIQUE" : "");
        }
        if (this.defaultValue != null) {
            builder.append(" DEFAULT ");
            builder.append("`").append(this.defaultValue).append("`");
        }
        return builder.toString();
    }

    public String foreignBuild() {
        return String.format(Queries.FOREIGN_VALUE.getString(), this.getName(), this.foreignKey().getTable().getName(), this.foreignKey().getName());
    }
}

