/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.sqlite;

import dev.tuxjsql.basic.builders.BasicSQLBuilder;
import dev.tuxjsql.basic.sql.BasicDataTypes;
import dev.tuxjsql.basic.sql.select.BasicJoinStatement;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.builders.ColumnBuilder;
import dev.tuxjsql.core.builders.TableBuilder;
import dev.tuxjsql.core.connection.ConnectionProvider;
import dev.tuxjsql.core.connection.ConnectionSettings;
import dev.tuxjsql.core.sql.DeleteStatement;
import dev.tuxjsql.core.sql.InsertStatement;
import dev.tuxjsql.core.sql.SQLDataType;
import dev.tuxjsql.core.sql.UpdateStatement;
import dev.tuxjsql.core.sql.select.JoinStatement;
import dev.tuxjsql.core.sql.select.SelectStatement;
import dev.tuxjsql.core.sql.where.SubWhereStatement;
import dev.tuxjsql.core.sql.where.WhereStatement;
import dev.tuxjsql.sqlite.SQLiteColumnBuilder;
import dev.tuxjsql.sqlite.SQLiteDeleteStatement;
import dev.tuxjsql.sqlite.SQLiteInsertStatement;
import dev.tuxjsql.sqlite.SQLiteSelectStatement;
import dev.tuxjsql.sqlite.SQLiteSubWhereStatement;
import dev.tuxjsql.sqlite.SQLiteTableBuilder;
import dev.tuxjsql.sqlite.SQLiteUpdateStatement;
import dev.tuxjsql.sqlite.SQLiteWhereStatement;
import java.io.File;
import java.util.Properties;

public final class SQLiteBuilder
extends BasicSQLBuilder {
    public static final String URL = "jdbc:sqlite:%1$s";
    public static final String JDBC_CLASS = "org.sqlite.JDBC";

    public TableBuilder createTable() {
        return new SQLiteTableBuilder(this.tuxJSQL);
    }

    public ColumnBuilder createColumn() {
        return new SQLiteColumnBuilder(this.tuxJSQL);
    }

    public WhereStatement createWhere() {
        return new SQLiteWhereStatement(this.tuxJSQL);
    }

    public SubWhereStatement createSubWhereStatement() {
        return new SQLiteSubWhereStatement(this.tuxJSQL);
    }

    public <T> WhereStatement<T> createWhere(T t) {
        return new SQLiteWhereStatement<T>(t, this.tuxJSQL);
    }

    public <T> SubWhereStatement<T> createSubWhereStatement(T t) {
        return new SQLiteSubWhereStatement<T>(t, this.tuxJSQL);
    }

    public SelectStatement createSelectStatement() {
        return new SQLiteSelectStatement(this.tuxJSQL);
    }

    public JoinStatement createJoinStatement(SelectStatement basicSelectStatement) {
        return new BasicJoinStatement(basicSelectStatement);
    }

    public UpdateStatement createUpdateStatement() {
        return new SQLiteUpdateStatement(this.tuxJSQL);
    }

    public DeleteStatement createDeleteStatement() {
        return new SQLiteDeleteStatement(this.tuxJSQL);
    }

    public String name() {
        return "SQLITE";
    }

    public String jdbcClass() {
        return JDBC_CLASS;
    }

    public SQLDataType convertDataType(BasicDataTypes dataType) {
        return dataType;
    }

    public InsertStatement createInsertStatement() {
        return new SQLiteInsertStatement(this.tuxJSQL);
    }

    public void configureConnectionProvider(ConnectionProvider provider, Properties userProperties) throws Exception {
        String url;
        if (userProperties.getProperty("db.file").equalsIgnoreCase("memory")) {
            url = String.format(URL, ":memory:");
        } else {
            File file = new File(userProperties.getProperty("db.file"));
            url = String.format(URL, file.getAbsolutePath());
        }
        if (TuxJSQL.getLogger().isDebugEnabled()) {
            TuxJSQL.getLogger().debug(String.format("URL:%s", url));
        }
        provider.setup(new ConnectionSettings(this.jdbcClass(), url), userProperties);
    }

    public <T> ColumnBuilder<T> createColumn(T t) {
        return new SQLiteColumnBuilder<T>(this.tuxJSQL, t);
    }
}

