/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.sqlite;

import dev.tuxjsql.basic.response.BasicDBInsert;
import dev.tuxjsql.basic.sql.BasicInsertStatement;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.response.DBAction;
import dev.tuxjsql.core.response.DBInsert;
import dev.tuxjsql.sqlite.Queries;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class SQLiteInsertStatement
extends BasicInsertStatement {
    public SQLiteInsertStatement(TuxJSQL tuxJSQL) {
        super(tuxJSQL);
    }

    public DBAction<DBInsert> execute() {
        return new DBAction(this::doInsert, this.tuxJSQL);
    }

    private DBInsert doInsert() {
        Object primaryKey;
        block45: {
            primaryKey = null;
            StringBuilder columnsToInsert = new StringBuilder();
            StringBuilder question = new StringBuilder();
            for (String column : this.values.keySet()) {
                if (!columnsToInsert.toString().isEmpty()) {
                    columnsToInsert.append(",");
                    question.append(",");
                }
                columnsToInsert.append("`").append(column).append("`");
                question.append("?");
            }
            String query = String.format(Queries.INSERT.getString(), this.table.getName(), columnsToInsert.toString(), question.toString());
            TuxJSQL.getLogger().debug(query);
            Object[] values = this.values.values().toArray();
            try (Connection connection = this.tuxJSQL.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(query);){
                int i = 1;
                for (Object object : values) {
                    preparedStatement.setObject(i++, object);
                }
                preparedStatement.executeUpdate();
                for (Map.Entry entry : this.values.entrySet()) {
                    if (!this.table.getColumn((String)entry.getKey()).primaryKey()) continue;
                    primaryKey = entry.getValue();
                }
                if (primaryKey != null) break block45;
                try {
                    Throwable throwable = null;
                    try (ResultSet set = preparedStatement.getGeneratedKeys();){
                        if (set != null && set.next()) {
                            primaryKey = set.getObject(1);
                        }
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    TuxJSQL.getLogger().error("Unable to get primaryKey for latest insert", (Throwable)e);
                }
            }
            catch (SQLException e) {
                TuxJSQL.getLogger().error("Unable to insert to table", (Throwable)e);
                return new BasicDBInsert(this.table, null, false);
            }
        }
        return new BasicDBInsert(this.table, primaryKey, true);
    }
}

