/*
 * Decompiled with CFR 0.152.
 */
package dev.tuxjsql.sqlite;

import dev.tuxjsql.basic.sql.BasicSQLTable;
import dev.tuxjsql.core.TuxJSQL;
import dev.tuxjsql.core.sql.SQLColumn;
import dev.tuxjsql.sqlite.Queries;
import java.util.List;

public class SQLiteTable
extends BasicSQLTable {
    public SQLiteTable(TuxJSQL tuxJSQL, String name, List<SQLColumn> sqlColumns) {
        super(tuxJSQL, name, sqlColumns);
    }

    public void prepareTable() {
        this.createTableIfNotExists();
    }

    public void createTableIfNotExists() {
        StringBuilder columns = new StringBuilder();
        int i = 0;
        for (SQLColumn column : this.sqlColumns) {
            if (i != 0) {
                columns.append(",");
            }
            columns.append(column.build());
            columns.append(" ");
            ++i;
        }
        for (SQLColumn c : this.sqlColumns) {
            if (!c.isForeignKey()) continue;
            columns.append(",");
            columns.append(c.foreignBuild());
            columns.append(" ");
        }
        String query = String.format(Queries.CREATE_TABLE_IF_NOT_EXISTS.getString(), this.name, columns.toString());
        this.executeStatement(query);
    }
}

