/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.metadata;

import dk.itst.oiosaml.configuration.SAMLConfiguration;
import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.security.SecurityHelper;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml2.metadata.AttributeService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;

public class IdpMetadata {
    public static final String VERSION = "$Id: IdpMetadata.java 2964 2008-06-02 11:34:06Z jre $";
    public static final String METADATA_DIRECTORY = "common.saml2.metadata.idp.directory";
    private static IdpMetadata instance;
    private static final Logger log;
    private final Map<String, Metadata> metadata = new HashMap<String, Metadata>();

    public IdpMetadata(String protocol, EntityDescriptor ... entityDescriptor) {
        for (EntityDescriptor descriptor : entityDescriptor) {
            if (this.metadata.containsKey(descriptor.getEntityID())) {
                this.metadata.get(descriptor.getEntityID()).addCertificates(new Metadata(descriptor, protocol).getCertificates());
                continue;
            }
            this.metadata.put(descriptor.getEntityID(), new Metadata(descriptor, protocol));
        }
    }

    public static IdpMetadata getInstance() {
        if (instance == null) {
            SAMLConfiguration configuration = SAMLConfigurationFactory.getConfiguration();
            String protocol = configuration.getSystemConfiguration().getString("oiosaml-sp.protocol");
            List<XMLObject> descriptors = configuration.getListOfIdpMetadata();
            instance = new IdpMetadata(protocol, descriptors.toArray(new EntityDescriptor[descriptors.size()]));
        }
        return instance;
    }

    public static void setMetadata(IdpMetadata metadata) {
        instance = metadata;
    }

    public Metadata getMetadata(String entityID) {
        Metadata md = this.metadata.get(entityID);
        if (md == null) {
            throw new IllegalArgumentException("No metadata found for " + entityID);
        }
        return md;
    }

    public boolean enableDiscovery() {
        return this.metadata.size() > 1;
    }

    public Metadata getFirstMetadata() {
        return this.getMetadata(this.getEntityIDs().iterator().next());
    }

    public Collection<String> getEntityIDs() {
        return this.metadata.keySet();
    }

    public Metadata findSupportedEntity(String ... entityIds) {
        for (String entityId : entityIds) {
            Metadata md = this.metadata.get(entityId);
            if (md == null) continue;
            return md;
        }
        log.debug("No supported idp found in " + Arrays.toString(entityIds) + ". Supported ids: " + this.metadata.keySet());
        return null;
    }

    static {
        log = LoggerFactory.getLogger(IdpMetadata.class);
    }

    public static class Metadata {
        private EntityDescriptor entityDescriptor;
        private IDPSSODescriptor idpSSODescriptor;
        private Collection<java.security.cert.X509Certificate> certificates = new ArrayList<java.security.cert.X509Certificate>();
        private Map<java.security.cert.X509Certificate, Date> validCertificates = new HashMap<java.security.cert.X509Certificate, Date>();

        private Metadata(EntityDescriptor entityDescriptor, String protocol) {
            this.entityDescriptor = entityDescriptor;
            this.idpSSODescriptor = entityDescriptor.getIDPSSODescriptor(protocol);
            try {
                java.security.cert.X509Certificate cert = SecurityHelper.buildJavaX509Cert(this.getCertificateNode().getValue());
                this.certificates.add(cert);
            }
            catch (CertificateException e) {
                throw new WrappedException(Layer.BUSINESS, (Throwable)e);
            }
        }

        public void addCertificates(Collection<java.security.cert.X509Certificate> certs) {
            this.certificates.addAll(certs);
        }

        public String getEntityID() {
            return this.entityDescriptor.getEntityID();
        }

        public String getArtifactResolutionServiceLocation(String binding) throws IllegalArgumentException {
            for (ArtifactResolutionService artifactResolutionService : this.idpSSODescriptor.getArtifactResolutionServices()) {
                if (!"urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equals(artifactResolutionService.getBinding())) continue;
                return artifactResolutionService.getLocation();
            }
            throw new IllegalArgumentException("No artifact resolution service for binding " + binding);
        }

        public String getSingleSignonServiceLocation(String binding) throws IllegalArgumentException {
            for (SingleSignOnService service : this.idpSSODescriptor.getSingleSignOnServices()) {
                if (!service.getBinding().equals(binding)) continue;
                return service.getLocation();
            }
            throw new IllegalArgumentException("Binding " + binding + " not found");
        }

        public String getAttributeQueryServiceLocation(String binding) throws IllegalArgumentException {
            AttributeAuthorityDescriptor descriptor = this.entityDescriptor.getAttributeAuthorityDescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
            if (descriptor == null) {
                throw new IllegalArgumentException("Metadata does not contain a AttributeAuthorityDescriptor");
            }
            for (AttributeService service : descriptor.getAttributeServices()) {
                if (!binding.equals(service.getBinding())) continue;
                return service.getLocation();
            }
            throw new IllegalArgumentException("Binding " + binding + " not found in AttributeServices");
        }

        public List<SingleSignOnService> getSingleSignonServices() {
            return this.idpSSODescriptor.getSingleSignOnServices();
        }

        public String getSingleLogoutServiceLocation() {
            String url = null;
            if (this.idpSSODescriptor.getSingleLogoutServices().size() > 0) {
                SingleLogoutService singleLogoutService = (SingleLogoutService)this.idpSSODescriptor.getSingleLogoutServices().get(0);
                url = singleLogoutService.getLocation();
            }
            return url;
        }

        public String getSingleLogoutServiceResponseLocation() {
            if (this.idpSSODescriptor.getSingleLogoutServices().size() > 0) {
                String location;
                List singleLogoutServices = this.idpSSODescriptor.getSingleLogoutServices();
                SingleLogoutService singleLogoutService = (SingleLogoutService)this.idpSSODescriptor.getSingleLogoutServices().get(0);
                for (SingleLogoutService sls : singleLogoutServices) {
                    if (!sls.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                    singleLogoutService = sls;
                    break;
                }
                if ((location = singleLogoutService.getResponseLocation()) == null) {
                    location = singleLogoutService.getLocation();
                }
                return location;
            }
            return null;
        }

        private X509Certificate getCertificateNode() {
            if (this.idpSSODescriptor != null && this.idpSSODescriptor.getKeyDescriptors().size() > 0) {
                X509Data x509Data;
                KeyDescriptor keyDescriptor = null;
                KeyDescriptor keyDescriptorUnspecified = null;
                for (KeyDescriptor kd : this.idpSSODescriptor.getKeyDescriptors()) {
                    if (kd.getUse().equals((Object)UsageType.SIGNING)) {
                        keyDescriptor = kd;
                        continue;
                    }
                    if (!kd.getUse().equals((Object)UsageType.UNSPECIFIED)) continue;
                    keyDescriptorUnspecified = kd;
                }
                if (keyDescriptor == null) {
                    keyDescriptor = keyDescriptorUnspecified;
                }
                if (keyDescriptor == null) {
                    throw new IllegalStateException("IdP Metadata does not contain a KeyDescriptor for signing: " + this.getEntityID());
                }
                if (keyDescriptor.getKeyInfo().getX509Datas().size() > 0 && (x509Data = (X509Data)keyDescriptor.getKeyInfo().getX509Datas().get(0)).getX509Certificates().size() > 0) {
                    return (X509Certificate)x509Data.getX509Certificates().get(0);
                }
            }
            throw new IllegalStateException("IdP Metadata does not contain a certificate: " + this.getEntityID());
        }

        Collection<java.security.cert.X509Certificate> getAllCertificates() {
            return this.certificates;
        }

        public Collection<java.security.cert.X509Certificate> getCertificates() {
            ArrayList<java.security.cert.X509Certificate> res = new ArrayList<java.security.cert.X509Certificate>();
            for (java.security.cert.X509Certificate cert : this.certificates) {
                if (cert.getNotAfter().after(new Date())) {
                    res.add(cert);
                    continue;
                }
                log.debug("Local Metadata certificateValidated for " + this.getEntityID() + " expired at " + cert.getNotAfter() + ", current: " + new Date());
            }
            return res;
        }

        public Collection<java.security.cert.X509Certificate> getValidCertificates() {
            ArrayList<java.security.cert.X509Certificate> res = new ArrayList<java.security.cert.X509Certificate>();
            for (java.security.cert.X509Certificate cert : this.validCertificates.keySet()) {
                if (cert.getNotAfter().after(new Date())) {
                    res.add(cert);
                    continue;
                }
                log.debug("Local Metadata certificateValidated for " + this.getEntityID() + " expired at " + cert.getNotAfter() + ", current: " + new Date());
            }
            return res;
        }

        public void setCertificateValid(java.security.cert.X509Certificate cert, boolean valid) {
            if (valid) {
                this.validCertificates.put(cert, new Date());
            } else {
                this.validCertificates.remove(cert);
            }
        }

        public Date getLastTimeForCertificationValidation(java.security.cert.X509Certificate certificate) {
            return this.validCertificates.get(certificate);
        }

        public Endpoint findLoginEndpoint(String[] bindings) {
            if (bindings == null) {
                throw new IllegalArgumentException("bindings cannot be null");
            }
            for (String binding : bindings) {
                for (SingleSignOnService service : this.idpSSODescriptor.getSingleSignOnServices()) {
                    if (!service.getBinding().equalsIgnoreCase(binding)) continue;
                    return service;
                }
            }
            throw new IllegalArgumentException("No SingleSignonService found for " + Arrays.toString(bindings));
        }

        public String getAttributeNameFormat(String attribute, String defaultFormat) {
            for (Attribute attr : this.idpSSODescriptor.getAttributes()) {
                if (!attribute.equals(attr.getName())) continue;
                return attr.getNameFormat();
            }
            return defaultFormat;
        }

        public Collection<PublicKey> getPublicKeys() {
            ArrayList<PublicKey> res = new ArrayList<PublicKey>();
            for (java.security.cert.X509Certificate cert : this.getCertificates()) {
                res.add(cert.getPublicKey());
            }
            return res;
        }
    }
}

