/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.session;

import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.util.Utils;
import org.apache.commons.configuration.Configuration;

public interface SessionHandlerFactory {
    public SessionHandler getHandler();

    public void close();

    public void configure(Configuration var1);

    public static class Factory {
        private static final Logger log = LoggerFactory.getLogger(SessionHandlerFactory.class);
        private static SessionHandlerFactory instance;

        public static synchronized SessionHandlerFactory newInstance(Configuration configuration) {
            if (log.isDebugEnabled()) {
                log.debug("Creating new handler factory: " + instance + ", config: " + configuration);
            }
            if (instance != null) {
                return instance;
            }
            if (configuration == null) {
                return null;
            }
            String name = configuration.getString("oiosaml-sp.sessionhandler.factory");
            if (log.isDebugEnabled()) {
                log.debug("Using session handler factory class: " + name);
            }
            SessionHandlerFactory factory = (SessionHandlerFactory)Utils.newInstance(configuration, "oiosaml-sp.sessionhandler.factory");
            factory.configure(configuration);
            instance = factory;
            return factory;
        }

        public static void close() {
            instance = null;
        }
    }
}

