/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.session.jdbc;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.service.session.Request;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.xml.util.Base64;

public class JdbcSessionHandler
implements SessionHandler {
    private static final Logger log = LoggerFactory.getLogger(JdbcSessionHandler.class);
    private final DataSource ds;
    private static int uniqueId = 0;
    private static int counter = 0;

    public JdbcSessionHandler(DataSource ds) {
        this.ds = ds;
    }

    private Connection getConnection() {
        try {
            Connection c = this.ds.getConnection();
            c.setAutoCommit(true);
            return c;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void closeConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            log.error("Unable to close connection", e);
        }
    }

    @Override
    public void cleanup(long requestIdsCleanupDelay, long sessionCleanupDelay) {
        Connection con = this.getConnection();
        String[] tables = new String[]{"assertions", "requests", "requestdata"};
        try {
            for (String table : tables) {
                PreparedStatement ps = con.prepareStatement("DELETE FROM " + table + " WHERE timestamp < ?");
                ps.setTimestamp(1, new Timestamp(new Date().getTime() - sessionCleanupDelay));
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    @Override
    public OIOAssertion getAssertion(String sessionId) {
        Connection con = this.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT assertion FROM assertions WHERE id = ?");
            ps.setString(1, sessionId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                OIOAssertion res = new OIOAssertion((Assertion)SAMLUtil.unmarshallElementFromString(rs.getString("assertion")));
                JdbcSessionHandler.updateTimestamp(sessionId, con);
                OIOAssertion oIOAssertion = res;
                return oIOAssertion;
            }
            OIOAssertion oIOAssertion = null;
            return oIOAssertion;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    private static void updateTimestamp(String id, Connection con) throws SQLException {
        PreparedStatement ps = con.prepareStatement("UPDATE assertions SET timestamp = ? WHERE id = ?");
        ps.setTimestamp(1, new Timestamp(new Date().getTime()));
        ps.setString(2, id);
        ps.executeUpdate();
        ps.close();
    }

    @Override
    public String getRelatedSessionId(String sessionIndex) {
        Connection con = this.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT id FROM assertions WHERE sessionindex = ?");
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("id");
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    @Override
    public Request getRequest(String state) throws IllegalArgumentException {
        Connection con = this.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT data FROM requestdata WHERE id = ?");
            ps.setString(1, state);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((String)rs.getString("data"))));
                Request result = (Request)is.readObject();
                ps = con.prepareStatement("DELETE FROM requestdata where id = ?");
                ps.setString(1, state);
                ps.executeUpdate();
                Request request = result;
                return request;
            }
            try {
                throw new IllegalArgumentException("No state with " + state + " registered");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    @Override
    public boolean isLoggedIn(String sessionId) {
        OIOAssertion ass = this.getAssertion(sessionId);
        return ass != null && !ass.hasSessionExpired();
    }

    @Override
    public void logOut(HttpSession session) {
        session.removeAttribute("dk.itst.oiosaml.userassertion");
        this.logOut(session.getId());
    }

    @Override
    public void logOut(String sessionId) {
        Connection con = this.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("DELETE FROM assertions WHERE id = ?");
            ps.setString(1, sessionId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    @Override
    public void registerRequest(String id, String receiverEntityID) {
        Connection con = this.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("INSERT INTO requests (id, receiver, timestamp) VALUES (?, ?, ?)");
            ps.setString(1, id);
            ps.setString(2, receiverEntityID);
            ps.setTimestamp(3, new Timestamp(new Date().getTime()));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    @Override
    public String removeEntityIdForRequest(String id) {
        Connection con = this.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT receiver FROM requests WHERE id = ?");
            ps.setString(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("receiver");
                return string;
            }
            try {
                throw new IllegalArgumentException("Request with id " + id + " is unknown");
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    @Override
    public void resetReplayProtection(int maxNum) {
        Connection con = this.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("DELETE FROM assertions");
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    @Override
    public String saveRequest(Request request) {
        Connection con = this.getConnection();
        try {
            String state = Utils.generateUUID();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(request);
            oos.close();
            String s = Base64.encodeBytes((byte[])bos.toByteArray());
            PreparedStatement ps = con.prepareStatement("INSERT INTO requestdata (id, data, timestamp) VALUES (?, ?, ?)");
            ps.setString(1, state);
            ps.setString(2, s);
            ps.setTimestamp(3, new Timestamp(new Date().getTime()));
            ps.executeUpdate();
            String string = state;
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    @Override
    public void setAssertion(String sessionId, OIOAssertion assertion) throws IllegalArgumentException {
        Connection con = this.getConnection();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT 1 FROM assertions WHERE assertionid = ? OR sessionindex = ?");
            ps.setString(1, assertion.getID());
            ps.setString(2, assertion.getSessionIndex());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                throw new IllegalArgumentException("Assertion with id " + assertion.getID() + " and sessionidx " + assertion.getSessionIndex() + " is already registered");
            }
            ps.close();
            ps = con.prepareStatement("DELETE FROM assertions WHERE id = ? OR sessionindex = ?");
            ps.setString(1, sessionId);
            ps.setString(2, assertion.getSessionIndex());
            if (ps.executeUpdate() > 0) {
                log.debug("Overwriting existing session info for session " + sessionId);
            }
            ps.close();
            ps = con.prepareStatement("INSERT INTO assertions (id, assertion, assertionid, sessionindex, timestamp) VALUES (?, ?, ?, ?, ?)");
            ps.setString(1, sessionId);
            ps.setString(2, assertion.toXML());
            ps.setString(3, assertion.getID());
            String sessionIndex = assertion.getSessionIndex();
            if (sessionIndex == null) {
                sessionIndex = this.getNextPassiveSessionIndex();
            }
            ps.setString(4, sessionIndex);
            ps.setTimestamp(5, new Timestamp(new Date().getTime()));
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcSessionHandler.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextPassiveSessionIndex() {
        String sessionIndex = null;
        JdbcSessionHandler jdbcSessionHandler = this;
        synchronized (jdbcSessionHandler) {
            Connection con = null;
            try {
                con = this.getConnection();
                for (int i = 0; i < 10; ++i) {
                    String attemptedSessionIndex = "Passive:" + uniqueId + "x" + ++counter;
                    PreparedStatement ps = con.prepareStatement("SELECT 1 FROM assertions WHERE sessionindex = ?");
                    ps.setString(1, attemptedSessionIndex);
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) {
                        sessionIndex = attemptedSessionIndex;
                        ps.close();
                        break;
                    }
                    ps.close();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                JdbcSessionHandler.closeConnection(con);
            }
        }
        if (sessionIndex == null) {
            throw new RuntimeException("Failed to aquire a unique sessionIndex for passive-login!");
        }
        return sessionIndex;
    }
}

