/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.util;

import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.session.Request;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class HTTPUtils {
    private static final Logger log = LoggerFactory.getLogger(HTTPUtils.class);

    private HTTPUtils() {
    }

    public static void sendMetaRedirect(HttpServletResponse res, String url, String query, boolean saveFragment) throws IOException {
        res.setContentType("text/html");
        HTTPUtils.sendCacheHeaders(res);
        PrintWriter w = res.getWriter();
        w.write("<html><head>");
        w.write("<meta http-equiv=\"refresh\" content=\"0;url=");
        w.write(url);
        if (query != null) {
            if (url.contains("?")) {
                w.write("&");
            } else {
                w.write("?");
            }
            w.write(query);
        }
        w.write("\">");
        w.write("</head><body>");
        if (saveFragment) {
            w.write("<script type=\"text/javascript\">document.cookie = 'oiosaml-fragment=' + escape(location.hash) + '; path=/';</script>");
        }
        w.write("</body></html>");
    }

    public static void sendCacheHeaders(HttpServletResponse res) {
        res.addHeader("Pragma", "no-cache");
        res.addDateHeader("Expires", -1L);
        res.addHeader("Cache-Control", "no-cache");
        res.addHeader("Cache-Control", "no-store");
    }

    public static String getFragmentCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!"oiosaml-fragment".equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void removeFragmentCookie(HttpServletResponse res) {
        Cookie c = new Cookie("oiosaml-fragment", "");
        c.setPath("/");
        c.setMaxAge(0);
        res.addCookie(c);
    }

    public static void sendResponse(Request req, RequestContext ctx) throws IOException, ServletException {
        HTTPUtils.sendCacheHeaders(ctx.getResponse());
        String home = ctx.getConfiguration().getString("oiosaml-sp.uri.home");
        if (req == null) {
            log.debug("No request saved in RelayState, redrecting to default url: " + home);
            ctx.getResponse().sendRedirect(home);
            return;
        }
        String uri = req.getRequestURI();
        if ("GET".equals(req.getMethod())) {
            String fragmentCookie;
            uri = uri.replaceAll("/[/]*", "/");
            StringBuilder sb = new StringBuilder(uri);
            if (req.getQueryString() != null) {
                sb.append("?");
                sb.append(req.getQueryString());
            }
            if ((fragmentCookie = HTTPUtils.getFragmentCookie(ctx.getRequest())) != null) {
                HTTPUtils.removeFragmentCookie(ctx.getResponse());
                sb.append(URLDecoder.decode(fragmentCookie, "utf-8"));
            }
            if (log.isDebugEnabled()) {
                log.debug("Saved GET request, redirecting to " + sb);
            }
            ctx.getResponse().sendRedirect(sb.toString());
        } else {
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            for (Map.Entry<String, String[]> e : req.getParameters().entrySet()) {
                ArrayList<String> values = new ArrayList<String>();
                for (String val : e.getValue()) {
                    values.add(Utils.htmlEntityEncode(val));
                }
                params.put(Utils.htmlEntityEncode(e.getKey()), values.toArray(new String[0]));
            }
            req = new Request(uri, req.getQueryString(), req.getMethod(), params);
            String postServlet = ctx.getConfiguration().getString("oiosaml-sp.repost", null);
            if (postServlet != null) {
                if (log.isDebugEnabled()) {
                    log.debug("POST Request with custom servlet at " + postServlet + " for action " + uri);
                }
                ctx.getRequest().setAttribute("request", (Object)req);
                ctx.getRequest().setAttribute("home", (Object)home);
                ctx.getRequest().getRequestDispatcher(postServlet).forward((ServletRequest)ctx.getRequest(), (ServletResponse)ctx.getResponse());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Saved POST request with default servlet for action " + uri);
                }
                VelocityContext vc = new VelocityContext();
                vc.put("request", (Object)req);
                vc.put("home", (Object)home);
                ctx.getResponse().setContentType("text/html");
                try {
                    HTTPUtils.getEngine().mergeTemplate("repost.vm", "UTF-8", (Context)vc, (Writer)ctx.getResponse().getWriter());
                }
                catch (Exception e1) {
                    log.error("Unable to render error template", e1);
                    throw new ServletException((Throwable)e1);
                }
            }
        }
    }

    public static VelocityEngine getEngine() {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("resource.loader", (Object)"classpath");
        engine.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            engine.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return engine;
    }
}

