/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.configuration;

import dk.itst.oiosaml.configuration.SAMLConfiguration;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import java.util.Iterator;
import java.util.ServiceLoader;

public class SAMLConfigurationFactory {
    private static final Logger log = LoggerFactory.getLogger(SAMLConfigurationFactory.class);
    private static SAMLConfiguration configuration;

    public static SAMLConfiguration getConfiguration() {
        if (configuration == null) {
            ServiceLoader<SAMLConfiguration> configurationImplementations = ServiceLoader.load(SAMLConfiguration.class);
            Iterator<SAMLConfiguration> iterator = configurationImplementations.iterator();
            while (iterator.hasNext()) {
                configuration = iterator.next();
                if (!iterator.hasNext()) continue;
                log.error("Appears to be more than one configuration implementation. Please check META-INF/services for occurencies. Choosing the implementation: " + configuration.getClass().getName());
                break;
            }
        }
        return configuration;
    }

    public static void reset() {
        configuration = null;
    }
}

