/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.logging;

import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4JLogger
implements Logger {
    private static boolean initialized = false;
    private static boolean initializationOngoing = false;
    private static Object lock = new Object();
    private org.apache.log4j.Logger log;

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void debug(Object message) {
        this.log.debug(message);
    }

    @Override
    public void debug(Object message, Throwable exception) {
        this.log.debug(message, exception);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    @Override
    public void info(Object message) {
        this.log.info(message);
    }

    @Override
    public void info(Object message, Throwable exception) {
        this.log.info(message, exception);
    }

    @Override
    public void warn(Object message) {
        this.log.warn(message);
    }

    @Override
    public void warn(Object message, Throwable exception) {
        this.log.warn(message, exception);
    }

    @Override
    public void error(Object message) {
        this.log.error(message);
    }

    @Override
    public void error(Object message, Throwable exception) {
        this.log.error(message, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String name) {
        this.log = org.apache.log4j.Logger.getLogger((String)name);
        Object object = lock;
        synchronized (object) {
            if (!initialized && !initializationOngoing) {
                String modified;
                Configuration systemConfiguration;
                initializationOngoing = true;
                try {
                    systemConfiguration = SAMLConfigurationFactory.getConfiguration().getSystemConfiguration();
                }
                catch (IllegalStateException e) {
                    this.error("Unable to retrieve configuration", e);
                    initializationOngoing = false;
                    initialized = true;
                    return;
                }
                String homeDir = systemConfiguration.getString("oiosaml.home");
                String logFileName = homeDir + systemConfiguration.getString("oiosaml-sp.log");
                StringBuilder contents = new StringBuilder();
                try {
                    int val;
                    BufferedReader input = new BufferedReader(new FileReader(logFileName));
                    while ((val = input.read()) != -1) {
                        contents.append((char)val);
                    }
                    input.close();
                    if (homeDir.endsWith(File.separator)) {
                        homeDir = homeDir.substring(0, homeDir.length() - 1);
                    }
                    modified = contents.toString().replaceAll("\\$\\{oiosaml.home\\}", homeDir.replace("\\", "/"));
                }
                catch (FileNotFoundException e) {
                    this.log.error((Object)("Unable to find log file. Tries to look for: " + logFileName));
                    throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
                }
                catch (IOException e) {
                    this.log.error((Object)"Unable to process log file.");
                    throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
                }
                ByteArrayInputStream log4jStream = new ByteArrayInputStream(modified.getBytes());
                try {
                    new DOMConfigurator().doConfigure((InputStream)log4jStream, LogManager.getLoggerRepository());
                }
                finally {
                    if (log4jStream != null) {
                        try {
                            log4jStream.close();
                        }
                        catch (IOException e) {
                            throw new WrappedException(Layer.UNDEFINED, (Throwable)e);
                        }
                    }
                }
                initializationOngoing = false;
                initialized = true;
            }
        }
    }
}

