/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.metadata;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.configuration.SAMLConfiguration;
import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.sp.model.OIOSamlObject;
import java.security.cert.CertificateEncodingException;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;

public class SPMetadata {
    public static final String VERSION = "$Id: SPMetadata.java 2950 2008-05-28 08:22:34Z jre $";
    private EntityDescriptor entityDescriptor;
    private SPSSODescriptor spSSODescriptor;
    private static SPMetadata instance;

    public SPMetadata(EntityDescriptor entityDescriptor, String protocol) {
        this.entityDescriptor = entityDescriptor;
        this.spSSODescriptor = entityDescriptor.getSPSSODescriptor(protocol);
    }

    public static SPMetadata getInstance() {
        if (instance == null) {
            SAMLConfiguration configuration = SAMLConfigurationFactory.getConfiguration();
            instance = new SPMetadata((EntityDescriptor)configuration.getSPMetaData(), configuration.getSystemConfiguration().getString("oiosaml-sp.protocol"));
        }
        return instance;
    }

    public static void setMetadata(SPMetadata metadata) {
        instance = metadata;
    }

    public String getEntityID() {
        return this.entityDescriptor.getEntityID();
    }

    public AssertionConsumerService getDefaultAssertionConsumerService() {
        AssertionConsumerService service = this.spSSODescriptor.getDefaultAssertionConsumerService();
        if (service != null) {
            return service;
        }
        if (this.spSSODescriptor.getAssertionConsumerServices().isEmpty()) {
            throw new IllegalStateException("No AssertionConsumerServices defined in SP metadata");
        }
        return (AssertionConsumerService)this.spSSODescriptor.getAssertionConsumerServices().get(0);
    }

    public String getAssertionConsumerServiceLocation(int index) {
        if (this.spSSODescriptor.getAssertionConsumerServices().size() > index) {
            AssertionConsumerService consumerService = (AssertionConsumerService)this.spSSODescriptor.getAssertionConsumerServices().get(index);
            return consumerService.getLocation();
        }
        return null;
    }

    public String getSingleLogoutServiceHTTPRedirectLocation() {
        for (SingleLogoutService singleLogoutService : this.spSSODescriptor.getSingleLogoutServices()) {
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService.getLocation();
        }
        return null;
    }

    public String getSingleLogoutServiceHTTPRedirectResponseLocation() {
        for (SingleLogoutService singleLogoutService : this.spSSODescriptor.getSingleLogoutServices()) {
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService.getResponseLocation();
        }
        return null;
    }

    public String getSingleLogoutServiceSOAPLocation() {
        for (SingleLogoutService singleLogoutService : this.spSSODescriptor.getSingleLogoutServices()) {
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService.getLocation();
        }
        return null;
    }

    public String getSingleLogoutServiceHTTPPostLocation() {
        for (SingleLogoutService singleLogoutService : this.spSSODescriptor.getSingleLogoutServices()) {
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService.getLocation();
        }
        return null;
    }

    public String getSingleLogoutServiceHTTPPostResponseLocation() {
        for (SingleLogoutService singleLogoutService : this.spSSODescriptor.getSingleLogoutServices()) {
            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(singleLogoutService.getBinding())) continue;
            return singleLogoutService.getResponseLocation();
        }
        return null;
    }

    public String getMetadata(Credential signingCredential, boolean sign) {
        X509Credential c = (X509Credential)signingCredential;
        EntityDescriptor e = SAMLUtil.clone(this.entityDescriptor);
        for (RoleDescriptor rd : e.getRoleDescriptors()) {
            for (KeyDescriptor k : rd.getKeyDescriptors()) {
                for (X509Data data : k.getKeyInfo().getX509Datas()) {
                    for (X509Certificate cert : data.getX509Certificates()) {
                        try {
                            cert.setValue(Base64.encodeBytes((byte[])c.getEntityCertificate().getEncoded()));
                        }
                        catch (CertificateEncodingException e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                }
            }
        }
        OIOSamlObject obj = new OIOSamlObject((XMLObject)e);
        if (sign) {
            obj.sign(signingCredential);
        }
        return obj.toXML();
    }
}

