/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model.validation;

import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.validation.BasicAssertionValidator;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnStatement;

public class OIOSAMLAssertionValidator
extends BasicAssertionValidator {
    private static final Logger log = LoggerFactory.getLogger(OIOSAMLAssertionValidator.class);

    @Override
    public void validate(OIOAssertion assertion, String spEntityId, String spAssertionConsumerURL) throws ValidationException {
        AuthnContextClassRef authnContextClassRef;
        super.validate(assertion, spEntityId, spAssertionConsumerURL);
        Assertion a = assertion.getAssertion();
        DateTime confirmationTime = assertion.getConfirmationTime();
        if (confirmationTime == null || !confirmationTime.isAfterNow()) {
            throw new ValidationException("Subject Confirmation Data is expired: " + confirmationTime + " before " + new DateTime());
        }
        if (a.getAuthnStatements().size() != 1) {
            throw new ValidationException("The assertion must contain exactly one AuthnStatement. Was " + a.getAuthnStatements().size());
        }
        int assuranceLevel = assertion.getAssuranceLevel();
        String authnContextClassRefValue = null;
        AuthnStatement authnStatement = (AuthnStatement)a.getAuthnStatements().get(0);
        AuthnContext authnContext = authnStatement.getAuthnContext();
        if (authnContext != null && (authnContextClassRef = authnContext.getAuthnContextClassRef()) != null) {
            authnContextClassRefValue = authnContextClassRef.getAuthnContextClassRef();
        }
        if (assuranceLevel == 2 && !"urn:oasis:names:tc:SAML:2.0:ac:classes:Password".equals(authnContextClassRefValue)) {
            log.warn("The assuranceLevel attribute " + assuranceLevel + "  in the assertion does not correspond with the value of AuthnStatement/AuthnContext/AuthnContextClassRef: " + authnContextClassRefValue);
        } else if (assuranceLevel == 3 && !"urn:oasis:names:tc:SAML:2.0:ac:classes:X509".equals(authnContextClassRefValue)) {
            log.warn("The assuranceLevel attribute " + assuranceLevel + "  in the assertion does not correspond with the value of AuthnStatement/AuthnContext/AuthnContextClassRef: " + authnContextClassRefValue);
        }
        if (assertion.getSessionIndex() == null) {
            throw new ValidationException("The assertion must contain a AuthnStatement@SessionIndex");
        }
        if (a.getAttributeStatements().size() != 1) {
            throw new ValidationException("The assertion must contain exactly one AttributeStatement. Contains " + a.getAttributeStatements().size());
        }
        if (a.getAuthzDecisionStatements().size() != 0) {
            throw new ValidationException("The assertion must not contain a AuthzDecisionStatement. Contains " + a.getAuthzDecisionStatements().size());
        }
        if (!assertion.checkRecipient(spAssertionConsumerURL)) {
            throw new ValidationException("The assertion must contain the recipient " + spAssertionConsumerURL);
        }
        if (authnStatement.getSessionNotOnOrAfter() != null && !authnStatement.getSessionNotOnOrAfter().isAfterNow()) {
            throw new ValidationException("The assertion must have a AuthnStatement@SessionNotOnOrAfter and it must not have expired. SessionNotOnOrAfter: " + authnStatement.getSessionNotOnOrAfter());
        }
    }
}

