/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.CertificateEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.util.Base64;

public class CertificateHandler
implements SAMLHandler {
    @Override
    public void handleGet(RequestContext context) throws ServletException, IOException {
        X509Credential cred = (X509Credential)context.getCredential();
        try {
            String cert = Base64.encodeBytes((byte[])cred.getEntityCertificate().getEncoded());
            HttpServletResponse res = context.getResponse();
            res.setContentType("text/plain");
            PrintWriter pw = res.getWriter();
            pw.println("-----BEGIN CERTIFICATE-----");
            pw.println(cert);
            pw.println("-----END CERTIFICATE-----");
            pw.close();
        }
        catch (CertificateEncodingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public void handlePost(RequestContext context) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }
}

