/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.UserAssertion;
import dk.itst.oiosaml.sp.UserAssertionHolder;
import dk.itst.oiosaml.sp.bindings.BindingHandler;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.model.OIOAuthnRequest;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import dk.itst.oiosaml.sp.service.util.HTTPUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.xml.util.Base64;

public class LoginHandler
implements SAMLHandler {
    private static final Logger log = LoggerFactory.getLogger(LoginHandler.class);

    @Override
    public void handleGet(RequestContext context) throws ServletException, IOException {
        IdpMetadata.Metadata metadata;
        if (log.isDebugEnabled()) {
            log.debug("Go to login...");
        }
        IdpMetadata idpMetadata = context.getIdpMetadata();
        Configuration conf = context.getConfiguration();
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        if (idpMetadata.enableDiscovery()) {
            log.debug("Discovery profile is active");
            String samlIdp = request.getParameter("_saml_idp");
            if (samlIdp == null) {
                String discoveryLocation = conf.getString("oiosaml-sp.discovery");
                log.debug("No _saml_idp discovery value found, redirecting to discovery service at " + discoveryLocation);
                String url = request.getRequestURL().toString();
                if (request.getQueryString() != null) {
                    url = url + "?" + request.getQueryString();
                }
                Audit.log(Operation.DISCOVER, true, "", discoveryLocation);
                HTTPUtils.sendMetaRedirect(response, discoveryLocation, "r=" + URLEncoder.encode(url, "UTF-8"), true);
                return;
            }
            if ("".equals(samlIdp)) {
                String defaultIdP = conf.getString("oiosaml-sp.discovery.default", null);
                if (defaultIdP != null) {
                    log.debug("No IdP discovered, using default IdP from configuration: " + defaultIdP);
                    metadata = idpMetadata.getMetadata(defaultIdP);
                } else {
                    if (conf.getBoolean("oiosaml-sp.discovery.prompt", false)) {
                        String url = request.getRequestURL().toString();
                        String relayState = request.getParameter("RelayState");
                        if (relayState != null) {
                            url = url + "?RelayState=" + relayState;
                        }
                        LoginHandler.promptIdp(context, url);
                        return;
                    }
                    log.debug("No IdP discovered, using first from metadata");
                    metadata = idpMetadata.getFirstMetadata();
                }
            } else {
                String[] entityIds = SAMLUtil.decodeDiscoveryValue(samlIdp);
                Audit.log(Operation.DISCOVER, false, "", Arrays.asList(entityIds).toString());
                metadata = idpMetadata.findSupportedEntity(entityIds);
                if (metadata != null) {
                    log.debug("Discovered idp " + metadata.getEntityID());
                } else {
                    log.debug("No supported IdP discovered, using first from metadata");
                    metadata = idpMetadata.getFirstMetadata();
                }
            }
        } else {
            metadata = idpMetadata.getFirstMetadata();
        }
        Audit.log(Operation.DISCOVER, metadata.getEntityID());
        Endpoint signonLocation = metadata.findLoginEndpoint(conf.getStringArray("oiosaml-sp.bindings"));
        if (signonLocation == null) {
            String msg = "Could not find a valid IdP signon location. Supported bindings: " + conf.getString("oiosaml-sp.bindings") + ", available: " + metadata.getSingleSignonServices();
            log.error(msg);
            throw new RuntimeException(msg);
        }
        log.debug("Signing on at " + signonLocation.getLocation());
        BindingHandler bindingHandler = context.getBindingHandlerFactory().getBindingHandler(signonLocation.getBinding());
        log.info("Using idp " + metadata.getEntityID() + " at " + signonLocation.getLocation() + " with binding " + signonLocation.getBinding());
        HttpSession session = context.getSession();
        UserAssertion ua = (UserAssertion)session.getAttribute("dk.itst.oiosaml.userassertion");
        session.removeAttribute("dk.itst.oiosaml.userassertion");
        UserAssertionHolder.set(null);
        String relayState = context.getRequest().getParameter("RelayState");
        OIOAuthnRequest authnRequest = OIOAuthnRequest.buildAuthnRequest(signonLocation.getLocation(), context.getSpMetadata().getEntityID(), context.getSpMetadata().getDefaultAssertionConsumerService().getBinding(), context.getSessionHandler(), relayState, context.getSpMetadata().getDefaultAssertionConsumerService().getLocation());
        authnRequest.setNameIDPolicy(conf.getString("oiosaml-sp.nameid.policy", null), conf.getBoolean("oiosaml-sp.nameid.allowcreate", false));
        authnRequest.setForceAuthn(LoginHandler.isForceAuthnEnabled(request, conf));
        if (ua == null) {
            authnRequest.setPasive(conf.getBoolean("oiosaml-sp.passive", false));
        }
        Audit.log(Operation.AUTHNREQUEST_SEND, true, authnRequest.getID(), authnRequest.toXML());
        context.getSessionHandler().registerRequest(authnRequest.getID(), metadata.getEntityID());
        bindingHandler.handle(request, response, context.getCredential(), authnRequest);
    }

    @Override
    public void handlePost(RequestContext context) throws ServletException, IOException {
        this.handleGet(context);
    }

    private static boolean isForceAuthnEnabled(HttpServletRequest servletRequest, Configuration conf) {
        Object[] urls = conf.getStringArray("oiosaml-sp.authn.force");
        if (urls == null) {
            return false;
        }
        String path = servletRequest.getPathInfo();
        if (path == null) {
            path = "/";
        }
        if (log.isDebugEnabled()) {
            log.debug("ForceAuthn urls: " + Arrays.toString(urls) + "; path: " + path);
        }
        for (Object url : urls) {
            if (!path.matches(((String)url).trim())) continue;
            if (log.isDebugEnabled()) {
                log.debug("Requested url " + path + " is in forceauthn list " + Arrays.toString(urls));
            }
            return true;
        }
        if (servletRequest.getParameterMap().containsKey("forceAuthn")) {
            String value = servletRequest.getParameter("forceAuthn");
            return value.toLowerCase().equals("true");
        }
        return false;
    }

    private static void promptIdp(RequestContext context, String returnUrl) throws ServletException, IOException {
        log.debug("Prompting user for IdP");
        HashMap<String, String> idps = new HashMap<String, String>();
        for (String id : context.getIdpMetadata().getEntityIDs()) {
            StringBuilder url = new StringBuilder(returnUrl);
            if (returnUrl.indexOf(63) > -1) {
                url.append("&");
            } else {
                url.append("?");
            }
            url.append("_saml_idp").append("=");
            url.append(Base64.encodeBytes((byte[])id.getBytes(), (int)8));
            idps.put(id, url.toString());
        }
        String servlet = context.getConfiguration().getString("oiosaml-sp.discovery.prompt.servlet", null);
        if (servlet != null) {
            HttpServletRequest request = context.getRequest();
            request.setAttribute("entityIds", idps);
            request.getRequestDispatcher(servlet).forward((ServletRequest)request, (ServletResponse)context.getResponse());
        } else {
            VelocityContext vc = new VelocityContext();
            vc.put("entityIds", idps);
            try {
                HTTPUtils.getEngine().mergeTemplate("idp.vm", "UTF-8", (Context)vc, (Writer)context.getResponse().getWriter());
            }
            catch (Exception e) {
                log.error("Unable to render IdP list", e);
                throw new ServletException((Throwable)e);
            }
        }
    }
}

