/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.AuthenticationHandler;
import dk.itst.oiosaml.sp.PassiveUserAssertion;
import dk.itst.oiosaml.sp.UserAssertion;
import dk.itst.oiosaml.sp.UserAssertionImpl;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.OIOResponse;
import dk.itst.oiosaml.sp.model.RelayState;
import dk.itst.oiosaml.sp.model.validation.AssertionValidator;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import dk.itst.oiosaml.sp.service.util.ArtifactExtractor;
import dk.itst.oiosaml.sp.service.util.HTTPUtils;
import dk.itst.oiosaml.sp.service.util.HttpSOAPClient;
import dk.itst.oiosaml.sp.service.util.PostResponseExtractor;
import dk.itst.oiosaml.sp.service.util.SOAPClient;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.opensaml.saml2.core.Assertion;

public class SAMLAssertionConsumerHandler
implements SAMLHandler {
    private static final long serialVersionUID = -8417816228519917989L;
    public static final String VERSION = "$Id: SAMLAssertionConsumerHandler.java 2910 2008-05-21 13:07:31Z jre $";
    private static final Logger log = LoggerFactory.getLogger(SAMLAssertionConsumerHandler.class);
    private SOAPClient client;
    private final AssertionValidator validator;

    public SAMLAssertionConsumerHandler(Configuration config) {
        this.validator = (AssertionValidator)Utils.newInstance(config, "oiosaml-sp.assertion.validator");
        this.setSoapClient(new HttpSOAPClient());
    }

    public void setSoapClient(SOAPClient soapClient) {
        this.client = soapClient;
    }

    @Override
    public void handlePost(RequestContext ctx) throws IOException, ServletException {
        PostResponseExtractor extractor = new PostResponseExtractor();
        this.handleSAMLResponse(ctx, extractor.extract(ctx.getRequest()));
    }

    @Override
    public void handleGet(RequestContext ctx) throws IOException, ServletException {
        if (ctx.getRequest().getParameter("SAMLResponse") != null) {
            this.handlePost(ctx);
        } else {
            ArtifactExtractor extractor = new ArtifactExtractor(ctx.getIdpMetadata(), ctx.getSpMetadata().getEntityID(), this.client, ctx.getConfiguration().getString("oiosaml-sp.resolve.username"), ctx.getConfiguration().getString("oiosaml-sp.resolve.password"), ctx.getConfiguration().getBoolean("oiosaml-sp.resolve.ignorecert", false));
            this.handleSAMLResponse(ctx, extractor.extract(ctx.getRequest()));
        }
    }

    private void handleSAMLResponse(RequestContext ctx, OIOResponse response) throws IOException, ServletException {
        Audit.log(Operation.AUTHNREQUEST_SEND, false, response.getInResponseTo(), response.toXML());
        HttpSession session = ctx.getSession();
        if (log.isDebugEnabled()) {
            log.debug("Calling URL.:" + ctx.getRequest().getRequestURI() + "?" + ctx.getRequest().getQueryString());
            log.debug("SessionId..:" + session.getId());
        }
        RelayState relayState = RelayState.fromRequest(ctx.getRequest());
        if (log.isDebugEnabled()) {
            log.debug("Got relayState..:" + relayState);
        }
        String idpEntityId = response.getOriginatingIdpEntityId(ctx.getSessionHandler());
        if (log.isDebugEnabled()) {
            log.debug("Received SAML Response from " + idpEntityId + ": " + response.toXML());
        }
        boolean allowPassive = ctx.getConfiguration().getBoolean("oiosaml-sp.passive", false);
        IdpMetadata.Metadata metadata = ctx.getIdpMetadata().getMetadata(idpEntityId);
        response.decryptAssertion(ctx.getCredential(), !ctx.getConfiguration().getBoolean("oiosaml-sp.encryption.force", false));
        response.validateResponse(ctx.getSpMetadata().getAssertionConsumerServiceLocation(0), metadata.getValidCertificates(), allowPassive);
        if (allowPassive && response.isPassive()) {
            log.debug("Received passive response, setting passive userassertion");
            Assertion assertion = SAMLUtil.buildXMLObject(Assertion.class);
            assertion.setID("" + System.currentTimeMillis());
            ctx.getSessionHandler().setAssertion(session.getId(), new OIOAssertion(assertion));
            PassiveUserAssertion passiveUserAssertion = new PassiveUserAssertion(ctx.getConfiguration().getString("oiosaml-sp.passive.user"));
            session.setAttribute("dk.itst.oiosaml.userassertion", (Object)passiveUserAssertion);
            Audit.log(Operation.LOGIN, passiveUserAssertion.getSubject());
        } else {
            OIOAssertion assertion = response.getAssertion();
            assertion.validateAssertion(this.validator, ctx.getSpMetadata().getEntityID(), ctx.getSpMetadata().getAssertionConsumerServiceLocation(0));
            UserAssertionImpl userAssertion = new UserAssertionImpl(assertion);
            if (!SAMLAssertionConsumerHandler.invokeAuthenticationHandler(ctx, userAssertion)) {
                Audit.logError(Operation.LOGIN, false, response.getInResponseTo(), "Authentication handler stopped authentication");
                log.error("Authentication handler stopped authentication");
                return;
            }
            Audit.setAssertionId(assertion.getID());
            Audit.log(Operation.LOGIN, assertion.getSubjectNameIDValue() + "/" + assertion.getAssuranceLevel() + " via " + assertion.getIssuer());
            Audit.log(Operation.LOGIN_SESSION, Integer.toString(session.getMaxInactiveInterval()));
            Assertion assertion2 = assertion.getAssertion();
            assertion2.releaseChildrenDOM(true);
            assertion2.releaseDOM();
            assertion2.detach();
            ctx.getSessionHandler().setAssertion(session.getId(), assertion);
            session.setAttribute("dk.itst.oiosaml.userassertion", (Object)userAssertion);
        }
        if (relayState.getRelayState() != null) {
            HTTPUtils.sendResponse(ctx.getSessionHandler().getRequest(relayState.getRelayState()), ctx);
        } else {
            HTTPUtils.sendResponse(null, ctx);
        }
    }

    private static boolean invokeAuthenticationHandler(RequestContext ctx, UserAssertion userAssertion) {
        String handlerClass = ctx.getConfiguration().getString("oiosaml-sp.authenticationhandler", null);
        if (handlerClass != null) {
            log.debug("Authentication handler: " + handlerClass);
            AuthenticationHandler handler = (AuthenticationHandler)Utils.newInstance(ctx.getConfiguration(), "oiosaml-sp.authenticationhandler");
            return handler.userAuthenticated(userAssertion, ctx.getRequest(), ctx.getResponse());
        }
        log.debug("No authentication handler configured");
        return true;
    }
}

