/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.util;

import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.sp.util.BRSArtifactType0004;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.opensaml.common.binding.BindingException;
import org.opensaml.saml2.binding.artifact.AbstractSAML2Artifact;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactBuilderFactory;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;

public class BRSArtifact {
    public static final String VERSION = "$Id: BRSArtifact.java 2829 2008-05-13 12:11:31Z jre $";
    private static SAML2ArtifactBuilderFactory artifactFactory = new SAML2ArtifactBuilderFactory();
    private SAML2ArtifactType0004 samlArtifact = null;
    private final String entityId;

    public BRSArtifact(String samlArt, String ... relyingParty) throws BindingException {
        this.samlArtifact = BRSArtifact.decodeArtifact(samlArt);
        this.entityId = this.validate(relyingParty);
    }

    private static SAML2ArtifactType0004 decodeArtifact(String samlArt) throws BindingException {
        byte[] artifactBytes = Base64.decode((String)samlArt);
        AbstractSAML2Artifact artifact = artifactFactory.buildArtifact(artifactBytes);
        if (artifact instanceof SAML2ArtifactType0004) {
            return (SAML2ArtifactType0004)artifact;
        }
        throw new BindingException("The artifact is not of the expected type: SAML2ArtifactType004");
    }

    private String validate(String ... relyingParties) throws BindingException {
        byte[] sourceID = this.samlArtifact.getSourceID();
        try {
            for (String entityID : relyingParties) {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                byte[] expectedSourceID = md.digest(entityID.getBytes("UTF-8"));
                if (!Arrays.equals(expectedSourceID, sourceID)) continue;
                return entityID;
            }
            throw new BindingException("The sourceID:" + new String(sourceID) + " does not match the expected sourceId");
        }
        catch (NoSuchAlgorithmException e) {
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
    }

    public int getEndpointIndex() {
        byte[] endpointIndex = this.samlArtifact.getEndpointIndex();
        int endpointIndexValue = 0;
        for (int i = 0; i < endpointIndex.length; ++i) {
            int shift = (endpointIndex.length - 1 - i) * 8;
            endpointIndexValue += (endpointIndex[i] & 0xFF) << shift;
        }
        return endpointIndexValue;
    }

    public static SAML2ArtifactType0004 buildArtifact(int endPointIndex, String entityID) {
        try {
            byte[] endpointIndex = DatatypeHelper.intToByteArray((int)endPointIndex);
            byte[] trimmedIndex = new byte[]{endpointIndex[2], endpointIndex[3]};
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] source = sha1Digester.digest(entityID.getBytes());
            SecureRandom handleGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] assertionHandle = new byte[20];
            handleGenerator.nextBytes(assertionHandle);
            return new BRSArtifactType0004(trimmedIndex, source, assertionHandle);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("JVM does not support required cryptography algorithms: SHA-1/SHA1PRNG.");
        }
    }

    public String getEntityId() {
        return this.entityId;
    }
}

