/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.common;

import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Artifact;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml2.metadata.Company;
import org.opensaml.saml2.metadata.EmailAddress;
import org.opensaml.saml2.metadata.GivenName;
import org.opensaml.saml2.metadata.LocalizedString;
import org.opensaml.saml2.metadata.NameIDFormat;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml2.metadata.OrganizationName;
import org.opensaml.saml2.metadata.OrganizationURL;
import org.opensaml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml2.metadata.ServiceName;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.SurName;
import org.opensaml.saml2.metadata.TelephoneNumber;
import org.opensaml.xml.ElementExtensibleXMLObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.KeyName;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SAMLUtil {
    public static final String VERSION = "$Id: BRSUtil.java 2910 2008-05-21 13:07:31Z jre $";
    private static final Logger log = LoggerFactory.getLogger(SAMLUtil.class);
    public static final String OIOSAML_HOME = "oiosaml.home";
    public static final String OIOSAML_DEFAULT_CONFIGURATION_FILE = "oiosaml-sp.properties";
    private static final Map<Class<?>, QName> elementCache = new ConcurrentHashMap();

    public static <T extends XMLObject> T buildXMLObject(Class<T> type) {
        try {
            QName objectQName = SAMLUtil.getElementQName(type);
            XMLObjectBuilder builder = Configuration.getBuilderFactory().getBuilder(objectQName);
            if (builder == null) {
                throw new InvalidParameterException("No builder exists for object: " + objectQName.getLocalPart());
            }
            return (T)builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> QName getElementQName(Class<T> type) {
        if (elementCache.containsKey(type)) {
            return elementCache.get(type);
        }
        try {
            Field typeField;
            try {
                typeField = type.getDeclaredField("DEFAULT_ELEMENT_NAME");
            }
            catch (NoSuchFieldException ex) {
                typeField = type.getDeclaredField("ELEMENT_NAME");
            }
            QName objectQName = (QName)typeField.get(null);
            elementCache.put(type, objectQName);
            return objectQName;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Issuer createIssuer(String value) {
        if (value == null) {
            return null;
        }
        Issuer issuer = SAMLUtil.buildXMLObject(Issuer.class);
        issuer.setValue(value);
        return issuer;
    }

    public static NameID createNameID(String nameIDValue) {
        NameID nameID = SAMLUtil.buildXMLObject(NameID.class);
        nameID.setValue(nameIDValue);
        nameID.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        return nameID;
    }

    public static SessionIndex createSessionIndex(String value) {
        SessionIndex sessionIndex = SAMLUtil.buildXMLObject(SessionIndex.class);
        sessionIndex.setSessionIndex(value);
        return sessionIndex;
    }

    public static Subject createSubject(String nameIDValue, String recipient, DateTime notOnOrAfter) {
        Subject subject = SAMLUtil.buildXMLObject(Subject.class);
        subject.setNameID(SAMLUtil.createNameID(nameIDValue));
        SubjectConfirmation subjectConfirmation = SAMLUtil.buildXMLObject(SubjectConfirmation.class);
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData subjectConfirmationData = SAMLUtil.buildXMLObject(SubjectConfirmationData.class);
        subjectConfirmationData.setRecipient(recipient);
        subjectConfirmationData.setNotOnOrAfter(notOnOrAfter);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        return subject;
    }

    public static AuthnContext createAuthnContext(String authnContextClassRefValue) {
        AuthnContext authnContext = SAMLUtil.buildXMLObject(AuthnContext.class);
        AuthnContextClassRef authnContextClassRef = SAMLUtil.buildXMLObject(AuthnContextClassRef.class);
        authnContextClassRef.setAuthnContextClassRef(authnContextClassRefValue);
        authnContext.setAuthnContextClassRef(authnContextClassRef);
        return authnContext;
    }

    public static Conditions createAudienceCondition(String audienceURI) {
        Audience audience = SAMLUtil.buildXMLObject(Audience.class);
        audience.setAudienceURI(audienceURI);
        AudienceRestriction audienceRestriction = SAMLUtil.buildXMLObject(AudienceRestriction.class);
        audienceRestriction.getAudiences().add(audience);
        Conditions conditions = SAMLUtil.buildXMLObject(Conditions.class);
        conditions.getAudienceRestrictions().add(audienceRestriction);
        return conditions;
    }

    public static Artifact createArtifact(String value) {
        Artifact artifact = SAMLUtil.buildXMLObject(Artifact.class);
        artifact.setArtifact(value);
        return artifact;
    }

    public static Status createStatus(String value) {
        Status status = SAMLUtil.buildXMLObject(Status.class);
        status.setStatusCode(SAMLUtil.buildXMLObject(StatusCode.class));
        status.getStatusCode().setValue(value);
        return status;
    }

    public static Signature createSignature(String keyName) {
        Signature signature = SAMLUtil.buildXMLObject(Signature.class);
        signature.setKeyInfo(SAMLUtil.buildXMLObject(KeyInfo.class));
        KeyName kn = SAMLUtil.buildXMLObject(KeyName.class);
        kn.setValue(keyName);
        signature.getKeyInfo().getKeyNames().add(kn);
        return signature;
    }

    public static EmailAddress createEmail(String email) {
        EmailAddress ea = SAMLUtil.buildXMLObject(EmailAddress.class);
        ea.setAddress(email);
        return ea;
    }

    public static Organization createOrganization(String name, String displayName, String url) {
        OrganizationDisplayName display = SAMLUtil.buildXMLObject(OrganizationDisplayName.class);
        display.setName(new LocalizedString(displayName, "en"));
        Organization org = SAMLUtil.buildXMLObject(Organization.class);
        org.getDisplayNames().add(display);
        OrganizationName orgName = SAMLUtil.buildXMLObject(OrganizationName.class);
        orgName.setName(new LocalizedString(name, "en"));
        org.getOrganizationNames().add(orgName);
        OrganizationURL orgUrl = SAMLUtil.buildXMLObject(OrganizationURL.class);
        orgUrl.setURL(new LocalizedString(url, "en"));
        org.getURLs().add(orgUrl);
        return org;
    }

    public static XMLObject unmarshallElement(InputStream input) {
        try {
            Element samlElement = SAMLUtil.loadElement(input);
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(samlElement);
            if (unmarshaller == null) {
                log.error("Unable to retrieve unmarshaller by DOM Element");
                throw new IllegalArgumentException("No unmarshaller for " + samlElement);
            }
            return unmarshaller.unmarshall(samlElement);
        }
        catch (UnmarshallingException e) {
            log.error("Unmarshalling failed when parsing element file " + input, e);
            return null;
        }
    }

    public static XMLObject unmarshallElement(Element element) {
        Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(element);
        if (unmarshaller == null) {
            log.error("Unable to retrieve unmarshaller by DOM Element " + element);
            throw new IllegalArgumentException("No unmarshaller for " + element);
        }
        try {
            return unmarshaller.unmarshall(element);
        }
        catch (UnmarshallingException e) {
            log.error("Unmarshalling failed when parsing element file " + element, e);
            return null;
        }
    }

    public static Element loadElement(InputStream input) {
        try {
            DocumentBuilderFactory newFactory = SAMLUtil.getDocumentBuilderFactory();
            DocumentBuilder builder = newFactory.newDocumentBuilder();
            Document doc = builder.parse(input);
            Element samlElement = doc.getDocumentElement();
            return samlElement;
        }
        catch (ParserConfigurationException e) {
            log.error("Unable to parse element file " + input, e);
        }
        catch (SAXException e) {
            log.error("Unable to parse element file " + input, e);
        }
        catch (IOException e) {
            log.error("Unable to parse element file " + input, e);
        }
        return null;
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory newFactory = DocumentBuilderFactory.newInstance();
        newFactory.setNamespaceAware(true);
        newFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        newFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        newFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        newFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        newFactory.setExpandEntityReferences(false);
        return newFactory;
    }

    public static XMLObject unmarshallElementFromString(String elementString) {
        try {
            Element samlElement = SAMLUtil.loadElementFromString(elementString);
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(samlElement);
            if (unmarshaller == null) {
                log.error("Unable to retrieve unmarshaller by DOM Element");
                throw new IllegalArgumentException("No unmarshaller for " + elementString);
            }
            return unmarshaller.unmarshall(samlElement);
        }
        catch (UnmarshallingException e) {
            log.error("Unmarshalling failed when parsing element string " + elementString, e);
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
    }

    public static Element loadElementFromString(String elementString) {
        try {
            DocumentBuilderFactory newFactory = SAMLUtil.getDocumentBuilderFactory();
            newFactory.setNamespaceAware(true);
            DocumentBuilder builder = newFactory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(elementString.getBytes("UTF-8")));
            Element samlElement = doc.getDocumentElement();
            return samlElement;
        }
        catch (ParserConfigurationException e) {
            log.error("Unable to parse element string " + elementString, e);
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
        catch (SAXException e) {
            log.error("Ue, nable to parse element string " + elementString, e);
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
        catch (IOException e) {
            log.error("Unable to parse element string " + elementString, e);
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
    }

    public static XMLObject unmarshallElementFromFile(String fileName) {
        File file = new File(fileName);
        if (!file.isFile() || !file.canRead()) {
            log.error("Can't find or read file " + fileName);
            throw new RuntimeException("Cannot find file " + fileName);
        }
        try {
            Element samlElement = SAMLUtil.loadElementFromFile(fileName);
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(samlElement);
            if (unmarshaller == null) {
                log.error("Unable to retrieve unmarshaller by DOM Element for {" + samlElement.getNamespaceURI() + "}" + samlElement.getLocalName());
                throw new IllegalArgumentException("No unmarshaller for element {" + samlElement.getNamespaceURI() + "}" + samlElement.getLocalName() + " from file " + fileName);
            }
            return unmarshaller.unmarshall(samlElement);
        }
        catch (UnmarshallingException e) {
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
    }

    public static Element loadElementFromFile(String fileName) {
        try {
            StringBuffer sb = new StringBuffer(2048);
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            char[] chars = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(chars)) != -1) {
                String readData = String.valueOf(chars, 0, numRead);
                sb.append(readData);
                chars = new char[1024];
            }
            reader.close();
            if (log.isDebugEnabled()) {
                log.debug(sb.toString());
            }
            return SAMLUtil.loadElementFromString(sb.toString());
        }
        catch (IOException e) {
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
    }

    public static String getSAMLObjectAsPrettyPrintXML(XMLObject object) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        Element e1 = SAMLUtil.marshallObject(object);
        return XMLHelper.prettyPrintXML((Node)e1);
    }

    public static Element marshallObject(XMLObject object) {
        if (object.getDOM() == null) {
            Marshaller m = Configuration.getMarshallerFactory().getMarshaller(object);
            if (m == null) {
                throw new IllegalArgumentException("No unmarshaller for " + object);
            }
            try {
                return m.marshall(object);
            }
            catch (MarshallingException e) {
                throw new WrappedException(Layer.CLIENT, (Throwable)e);
            }
        }
        return object.getDOM();
    }

    public static AssertionConsumerService createAssertionConsumerService(String location, String binding, int index, boolean isDefault) {
        AssertionConsumerService acs = SAMLUtil.buildXMLObject(AssertionConsumerService.class);
        acs.setBinding(binding);
        acs.setIndex(Integer.valueOf(index));
        acs.setLocation(location);
        acs.setIsDefault(Boolean.valueOf(isDefault));
        return acs;
    }

    public static SingleLogoutService createSingleLogoutService(String location, String responseLocation, String binding) {
        SingleLogoutService sls = SAMLUtil.buildXMLObject(SingleLogoutService.class);
        sls.setBinding(binding);
        sls.setLocation(location);
        sls.setResponseLocation(responseLocation);
        return sls;
    }

    public static ArtifactResolutionService createArtifactResolutionService(String location) {
        ArtifactResolutionService ars = SAMLUtil.buildXMLObject(ArtifactResolutionService.class);
        ars.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact");
        ars.setIndex(Integer.valueOf(0));
        ars.setIsDefault(Boolean.valueOf(true));
        ars.setLocation(location);
        return ars;
    }

    public static RequestedAttribute createRequestedAttribute(String attribute, String format, boolean required) {
        RequestedAttribute attr = SAMLUtil.buildXMLObject(RequestedAttribute.class);
        attr.setIsRequired(Boolean.valueOf(required));
        attr.setName(attribute);
        attr.setNameFormat(format);
        return attr;
    }

    public static NameIDFormat createNameIDFormat(String format) {
        NameIDFormat nameIdFormat = SAMLUtil.buildXMLObject(NameIDFormat.class);
        nameIdFormat.setFormat(format);
        return nameIdFormat;
    }

    public static AttributeConsumingService createAttributeConsumingService(String serviceName) {
        AttributeConsumingService service = SAMLUtil.buildXMLObject(AttributeConsumingService.class);
        ServiceName name = SAMLUtil.buildXMLObject(ServiceName.class);
        name.setName(new LocalizedString(serviceName, "en"));
        service.getNames().add(name);
        service.setIndex(0);
        service.setIsDefault(Boolean.valueOf(true));
        return service;
    }

    public static String[] decodeDiscoveryValue(String value) {
        if (value == null) {
            return new String[0];
        }
        String[] ids = value.split(" ");
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = new String(Base64.decode((String)ids[i]));
        }
        return ids;
    }

    public static RequestedAuthnContext createRequestedAuthnContext(List<String> references) {
        RequestedAuthnContext c = SAMLUtil.buildXMLObject(RequestedAuthnContext.class);
        c.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
        for (String reference : references) {
            AuthnContextClassRef authnContextClassRef = SAMLUtil.buildXMLObject(AuthnContextClassRef.class);
            authnContextClassRef.setAuthnContextClassRef(reference);
            c.getAuthnContextClassRefs().add(authnContextClassRef);
        }
        return c;
    }

    public static Company createCompany(String orgName) {
        Company c = SAMLUtil.buildXMLObject(Company.class);
        c.setName(orgName);
        return c;
    }

    public static GivenName createGivenName(String givenName) {
        GivenName g = SAMLUtil.buildXMLObject(GivenName.class);
        g.setName(givenName);
        return g;
    }

    public static TelephoneNumber createTelephoneNumber(String phone) {
        TelephoneNumber t = SAMLUtil.buildXMLObject(TelephoneNumber.class);
        t.setNumber(phone);
        return t;
    }

    public static SurName createSurName(String surName) {
        SurName s = SAMLUtil.buildXMLObject(SurName.class);
        s.setName(surName);
        return s;
    }

    public static <T extends XMLObject> T getFirstElement(ElementExtensibleXMLObject obj, Class<T> type) {
        if (obj == null) {
            return null;
        }
        for (XMLObject o : obj.getUnknownXMLObjects()) {
            if (!type.isInstance(o)) continue;
            return (T)o;
        }
        return null;
    }

    public static <T extends XMLObject> T clone(T object) {
        return (T)SAMLUtil.unmarshallElementFromString(XMLHelper.nodeToString((Node)SAMLUtil.marshallObject(object)));
    }
}

