/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.configuration;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.configuration.SAMLConfiguration;
import dk.itst.oiosaml.configuration.SystemConfiguration;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.helper.DeveloperHelper;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.service.session.SameSiteSessionSynchronizer;
import dk.itst.oiosaml.sp.service.session.SessionCopyListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.xml.XMLObject;

public class FileConfiguration
implements SAMLConfiguration {
    private static final Logger log = LoggerFactory.getLogger(FileConfiguration.class);
    private String homeDir;
    private String configurationFileName;
    private Configuration systemConfiguration;
    private SameSiteSessionSynchronizer sameSiteSessionSynchronizer;

    public FileConfiguration() {
        String applicationName = SystemConfiguration.getApplicationName();
        if (applicationName != null) {
            log.info("oiosaml-j.name set to " + applicationName + " in web.xml");
        } else {
            log.info("oiosaml-j.name was not defined in web.xml.");
        }
        String homeParam = SystemConfiguration.getHomeDir();
        if (homeParam != null) {
            log.info("oiosaml-j.home set to " + homeParam + " in web.xml");
        } else {
            log.info("oiosaml-j.home was not defined in web.xml.");
        }
        String fullPathToConfigurationFile = SystemConfiguration.getFullPathToConfigurationFile();
        if (fullPathToConfigurationFile != null) {
            log.info("oiosaml-j.file set to " + fullPathToConfigurationFile + " in web.xml");
        } else {
            log.info("oiosaml-j.file was not defined in web.xml.");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (fullPathToConfigurationFile != null) {
            params.put("oiosaml-j.file", fullPathToConfigurationFile);
        } else {
            if (homeParam == null) {
                homeParam = System.getProperty("oiosaml.home");
                log.info("oiosaml-j.home not set in web.xml. Setting it to oiosaml.home Java system property with value: " + homeParam);
            }
            if (homeParam == null) {
                homeParam = System.getProperty("user.home") + File.separator + ".oiosaml";
                log.info("oiosaml-j.home not set in Java system property. Setting it to default path: " + homeParam);
            }
            params.put("oiosaml-j.home", homeParam);
            params.put("oiosaml-j.name", applicationName);
        }
        this.setInitConfiguration(params);
    }

    @Override
    public Configuration getSystemConfiguration() throws IllegalStateException {
        if (this.systemConfiguration != null) {
            return this.systemConfiguration;
        }
        if (this.homeDir == null || !this.isConfigured()) {
            throw new IllegalStateException("System not configured");
        }
        CompositeConfiguration conf = new CompositeConfiguration();
        conf.setProperty("oiosaml.home", (Object)this.homeDir);
        try {
            conf.addConfiguration((Configuration)new PropertiesConfiguration(new File(this.homeDir, this.configurationFileName)));
            conf.addConfiguration(this.getCommonConfiguration());
            this.systemConfiguration = conf;
            return this.systemConfiguration;
        }
        catch (ConfigurationException e) {
            log.error("Cannot load the configuration file", e);
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
        catch (IOException e) {
            log.error("Unable to load oiosaml-common.propeties from classpath", e);
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
    }

    @Override
    public SameSiteSessionSynchronizer getSameSiteSessionSynchronizer() {
        if (this.sameSiteSessionSynchronizer != null) {
            return this.sameSiteSessionSynchronizer;
        }
        try {
            String handlerClass = this.getSystemConfiguration().getString("oiosaml-sp.samesite.handler", "dk.itst.oiosaml.sp.service.session.SessionCopyListener");
            Class<?> clazz = Class.forName(handlerClass);
            return (SameSiteSessionSynchronizer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            log.error("Failed to initialize SameSiteSessionSynchronizer - defaulting to SessionCopyListener", ex);
            return new SessionCopyListener();
        }
    }

    @Override
    public Configuration getCommonConfiguration() throws IOException {
        CompositeConfiguration conf = new CompositeConfiguration();
        Enumeration<URL> resources = SAMLConfiguration.class.getClassLoader().getResources("oiosaml-common.properties");
        while (resources.hasMoreElements()) {
            URL u = resources.nextElement();
            log.debug("Loading config from " + u);
            try {
                conf.addConfiguration((Configuration)new PropertiesConfiguration(u));
            }
            catch (ConfigurationException e) {
                log.error("Cannot load the configuration file", e);
                throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
            }
        }
        return conf;
    }

    @Override
    public boolean isConfigured() {
        if (this.homeDir == null) {
            return false;
        }
        log.info("Config filename: " + this.homeDir + this.configurationFileName);
        File config = new File(this.homeDir + this.configurationFileName);
        log.info("Looking in : " + config.getAbsolutePath());
        return config.exists();
    }

    @Override
    public KeyStore getKeystore() throws WrappedException {
        KeyStore keystore = null;
        File keystoreFile = new File(this.getSystemConfiguration().getString("oiosaml-sp.certificate.location"));
        if (!keystoreFile.exists()) {
            keystoreFile = new File(this.homeDir + this.getSystemConfiguration().getString("oiosaml-sp.certificate.location"));
        }
        try {
            InputStream input = new FileInputStream(keystoreFile);
            input = new BufferedInputStream(input);
            input.mark(0x100000);
            try {
                keystore = FileConfiguration.loadStore(input, this.getSystemConfiguration().getString("oiosaml-sp.certificate.password"), "PKCS12");
            }
            catch (IOException e) {
                log.debug("Keystore is not of type 'PCKS12' Trying type 'JKS'.");
                try {
                    input.reset();
                    keystore = FileConfiguration.loadStore(input, this.getSystemConfiguration().getString("oiosaml-sp.certificate.password"), "JKS");
                }
                catch (IOException ioe) {
                    DeveloperHelper.log("It is not possible to access the configured keystore. Please check that the configured path and password are correct.");
                    log.error("Unable to find keystore file. Looking for: " + keystoreFile.getAbsolutePath());
                    throw new WrappedException(Layer.DATAACCESS, (Throwable)ioe);
                }
                catch (Exception ec) {
                    log.error("Exception occured while processing keystore: " + keystoreFile.getAbsolutePath());
                    throw new WrappedException(Layer.DATAACCESS, (Throwable)ec);
                }
            }
            catch (Exception ex) {
                log.error("Exception occured while processing keystore: " + keystoreFile.getAbsolutePath());
                throw new WrappedException(Layer.DATAACCESS, (Throwable)ex);
            }
        }
        catch (FileNotFoundException e) {
            log.error("Unable to find keystore file. Looking for: " + keystoreFile.getAbsolutePath());
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
        return keystore;
    }

    private static KeyStore loadStore(InputStream input, String password, String type) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(type);
        char[] jksPassword = password.toCharArray();
        ks.load(input, jksPassword);
        input.close();
        return ks;
    }

    @Override
    public XMLObject getSPMetaData() throws WrappedException {
        String filename = this.getSystemConfiguration().getString("common.saml2.metadata.sp.filename");
        String directory = this.homeDir + this.getSystemConfiguration().getString("common.saml2.metadata.sp.directory");
        String spMetadataFileName = directory + "/" + filename;
        XMLObject unmarshallElementFromFile = null;
        try {
            unmarshallElementFromFile = SAMLUtil.unmarshallElementFromFile(spMetadataFileName);
        }
        catch (Exception e) {
            log.error("Unable to find SP metadata file. Tries to look for: " + spMetadataFileName);
            throw new WrappedException(Layer.DATAACCESS, (Throwable)e);
        }
        return unmarshallElementFromFile;
    }

    @Override
    public List<XMLObject> getListOfIdpMetadata() throws WrappedException {
        ArrayList<XMLObject> descriptors = new ArrayList<XMLObject>();
        String protocol = this.getSystemConfiguration().getString("oiosaml-sp.protocol");
        if (this.getSystemConfiguration().getString("common.saml2.metadata.idp.filename") != null) {
            String idpFileName = this.homeDir + this.getSystemConfiguration().getString("common.saml2.metadata.idp.directory") + "/" + this.getSystemConfiguration().getString("common.saml2.metadata.idp.filename");
            File md = new File(idpFileName);
            log.info("Loading " + protocol + " metadata from " + md);
            try {
                XMLObject descriptor = SAMLUtil.unmarshallElementFromFile(md.getAbsolutePath());
                if (descriptor instanceof EntityDescriptor) {
                    descriptors.add(descriptor);
                }
                if (descriptor instanceof EntitiesDescriptor) {
                    EntitiesDescriptor desc = (EntitiesDescriptor)descriptor;
                    descriptors.addAll(desc.getEntityDescriptors());
                }
                throw new RuntimeException("Metadata file " + md + " does not contain an EntityDescriptor. Found " + descriptor.getElementQName() + ", expected " + EntityDescriptor.ELEMENT_QNAME);
            }
            catch (RuntimeException e) {
                log.error("Unable to load metadata from " + md + ". File must contain valid XML and have EntityDescriptor as top tag", e);
                throw e;
            }
        } else {
            String directory = this.homeDir + this.getSystemConfiguration().getString("common.saml2.metadata.idp.directory");
            File idpDir = new File(directory);
            File[] files = idpDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".xml");
                }
            });
            if (files != null) {
                for (File md : files) {
                    log.info("Loading " + protocol + " metadata from " + md);
                    try {
                        XMLObject descriptor = SAMLUtil.unmarshallElementFromFile(md.getAbsolutePath());
                        if (descriptor instanceof EntityDescriptor) {
                            descriptors.add(descriptor);
                            continue;
                        }
                        if (descriptor instanceof EntitiesDescriptor) {
                            EntitiesDescriptor desc = (EntitiesDescriptor)descriptor;
                            descriptors.addAll(desc.getEntityDescriptors());
                            continue;
                        }
                        throw new RuntimeException("Metadata file " + md + " does not contain an EntityDescriptor. Found " + descriptor.getElementQName() + ", expected " + EntityDescriptor.ELEMENT_QNAME);
                    }
                    catch (RuntimeException e) {
                        log.error("Unable to load metadata from " + md + ". File must contain valid XML and have EntityDescriptor as top tag", e);
                        throw e;
                    }
                }
            }
        }
        if (descriptors.isEmpty()) {
            throw new IllegalStateException("No IdP descriptors found in ! At least one file is required.");
        }
        return descriptors;
    }

    @Override
    public void setInitConfiguration(Map<String, String> params) {
        this.systemConfiguration = null;
        if (params != null) {
            if (params.containsKey("oiosaml-j.file")) {
                String configurationFile = params.get("oiosaml-j.file");
                if (configurationFile != null) {
                    int lastPathSeperatorIndex = configurationFile.lastIndexOf(File.separator) + 1;
                    this.configurationFileName = configurationFile.substring(lastPathSeperatorIndex, configurationFile.length());
                    this.homeDir = configurationFile.substring(0, lastPathSeperatorIndex);
                }
            } else if (params.containsKey("oiosaml-j.home")) {
                String applicationName;
                String pathToConfigurationFolder = params.get("oiosaml-j.home");
                if (pathToConfigurationFolder != null) {
                    this.homeDir = pathToConfigurationFolder;
                    this.configurationFileName = "oiosaml-sp.properties";
                }
                if ((applicationName = params.get("oiosaml-j.name")) != null && !applicationName.trim().isEmpty()) {
                    if (this.homeDir.endsWith(File.separator)) {
                        this.homeDir = this.homeDir.substring(0, this.homeDir.length() - 1);
                    }
                    this.homeDir = this.homeDir + "-" + applicationName;
                }
                if (!this.homeDir.endsWith(File.separator)) {
                    this.homeDir = this.homeDir + File.separator;
                }
            } else {
                this.homeDir = null;
                this.configurationFileName = null;
            }
            log.info("Path to configuration folder set to: " + this.homeDir);
            log.info("Configuration file name set to: " + this.configurationFileName);
        }
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.systemConfiguration = configuration;
    }

    public String getHomeDir() {
        return this.homeDir;
    }
}

