/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.security;

import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensaml.xml.security.x509.BasicX509Credential;

public class CredentialRepository {
    private static final Logger log = LoggerFactory.getLogger(CredentialRepository.class);
    private final Map<Key, BasicX509Credential> credentials = new ConcurrentHashMap<Key, BasicX509Credential>();

    public BasicX509Credential getCredential(KeyStore keystore, String password, String credentialsCacheKey) {
        Key key = new Key(credentialsCacheKey, password);
        BasicX509Credential credential = this.credentials.get(key);
        if (credential == null) {
            credential = CredentialRepository.createCredential(keystore, password);
            this.credentials.put(key, credential);
        }
        return credential;
    }

    public BasicX509Credential getCredential(KeyStore keystore, String password) {
        return this.getCredential(keystore, password, "oiosaml-sp.certificate.location");
    }

    public Collection<BasicX509Credential> getCredentials() {
        return this.credentials.values();
    }

    public X509Certificate getCertificate(KeyStore keystore, String password, String alias, String credentialsCacheKey) {
        BasicX509Credential credential = null;
        if (credentialsCacheKey != null) {
            Key key = new Key(credentialsCacheKey, password, alias);
            credential = this.credentials.get(key);
        }
        if (credential == null) {
            try {
                if (alias == null) {
                    Enumeration<String> eAliases = keystore.aliases();
                    while (eAliases.hasMoreElements()) {
                        String strAlias = eAliases.nextElement();
                        log.debug("Trying " + strAlias);
                        if (!keystore.isCertificateEntry(strAlias)) continue;
                        X509Certificate certificate = (X509Certificate)keystore.getCertificate(strAlias);
                        credential = new BasicX509Credential();
                        credential.setEntityCertificate(certificate);
                        if (credentialsCacheKey != null) {
                            this.credentials.put(new Key(credentialsCacheKey, password, strAlias), credential);
                        }
                        alias = strAlias;
                    }
                }
                log.debug("Getting certificate from alias " + alias);
                if (credentialsCacheKey != null) {
                    credential = this.credentials.get(new Key(credentialsCacheKey, password, alias));
                }
                if (credential == null) {
                    throw new NullPointerException("Unable to find certificate for " + alias);
                }
            }
            catch (GeneralSecurityException e) {
                throw new WrappedException(Layer.CLIENT, (Throwable)e);
            }
        }
        return credential.getEntityCertificate();
    }

    public static BasicX509Credential createCredential(KeyStore ks, String password) {
        BasicX509Credential credential = new BasicX509Credential();
        try {
            Enumeration<String> eAliases = ks.aliases();
            while (eAliases.hasMoreElements()) {
                String strAlias = eAliases.nextElement();
                if (!ks.isKeyEntry(strAlias)) continue;
                PrivateKey privateKey = (PrivateKey)ks.getKey(strAlias, password.toCharArray());
                credential.setPrivateKey(privateKey);
                credential.setEntityCertificate((X509Certificate)ks.getCertificate(strAlias));
                PublicKey publicKey = ks.getCertificate(strAlias).getPublicKey();
                if (log.isDebugEnabled()) {
                    log.debug("publicKey..:" + publicKey + ", privateKey: " + privateKey);
                }
                credential.setPublicKey(publicKey);
            }
        }
        catch (GeneralSecurityException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        return credential;
    }

    public X509Certificate getCertificate(KeyStore keystore, String password, String alias) {
        return this.getCertificate(keystore, password, alias, "oiosaml-sp.certificate.location");
    }

    private static class Key {
        private final String location;
        private final String password;
        private final String alias;

        public Key(String location, String password) {
            this.location = location;
            this.password = password;
            this.alias = null;
        }

        public Key(String location, String password, String alias) {
            this.location = location;
            this.password = password;
            this.alias = alias;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
                return false;
            }
            if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
                return false;
            }
            return !(this.password == null ? other.password != null : !this.password.equals(other.password));
        }
    }
}

