/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp;

import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.error.InvalidCertificateException;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.security.CredentialRepository;
import dk.itst.oiosaml.sp.NameIDFormat;
import dk.itst.oiosaml.sp.UserAssertionHolder;
import dk.itst.oiosaml.sp.UserAttribute;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.metadata.SPMetadata;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.OIOAttributeQuery;
import dk.itst.oiosaml.sp.service.util.HttpSOAPClient;
import dk.itst.oiosaml.sp.service.util.SOAPClient;
import dk.itst.oiosaml.sp.util.AttributeUtil;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.security.credential.Credential;

public class UserAttributeQuery {
    private static final CredentialRepository credentialRepository = new CredentialRepository();
    private final String username;
    private final String password;
    private final SOAPClient client;
    private final Credential credential;
    private final boolean ignoreCertPath;
    private final boolean requireEncryption;
    private final IdpMetadata.Metadata idpMetadata;
    private final String spEntityId;

    public UserAttributeQuery() throws WrappedException, NoSuchAlgorithmException, CertificateException, IllegalStateException, KeyStoreException, IOException {
        this(SAMLConfigurationFactory.getConfiguration().getSystemConfiguration().getString("oiosaml-sp.resolve.username", null), SAMLConfigurationFactory.getConfiguration().getSystemConfiguration().getString("oiosaml-sp.resolve.password", null));
    }

    public UserAttributeQuery(String username, String password) throws WrappedException, NoSuchAlgorithmException, CertificateException, IllegalStateException, KeyStoreException, IOException {
        this(UserAssertionHolder.get() != null ? UserAssertionHolder.get().getIssuer() : null, username, password);
    }

    public UserAttributeQuery(String idpEntityId, String username, String password) throws WrappedException, NoSuchAlgorithmException, CertificateException, IllegalStateException, KeyStoreException, IOException {
        this(IdpMetadata.getInstance().getMetadata(idpEntityId), username, password, new HttpSOAPClient(), (Credential)credentialRepository.getCredential(SAMLConfigurationFactory.getConfiguration().getKeystore(), SAMLConfigurationFactory.getConfiguration().getSystemConfiguration().getString("oiosaml-sp.certificate.password")), SAMLConfigurationFactory.getConfiguration().getSystemConfiguration().getBoolean("oiosaml-sp.resolve.ignorecert", false), SAMLConfigurationFactory.getConfiguration().getSystemConfiguration().getBoolean("oiosaml-sp.encryption.force", true), SPMetadata.getInstance().getEntityID());
    }

    public UserAttributeQuery(IdpMetadata.Metadata idpMetadata, String username, String password, SOAPClient client, Credential credential, boolean ignoreCertPath, boolean requireEncryption, String spEntityId) {
        this.spEntityId = spEntityId;
        if (idpMetadata == null) {
            throw new IllegalArgumentException("IdP Metadata cannot be null");
        }
        this.idpMetadata = idpMetadata;
        this.username = username;
        this.password = password;
        this.client = client;
        this.credential = credential;
        this.ignoreCertPath = ignoreCertPath;
        this.requireEncryption = requireEncryption;
    }

    public Collection<UserAttribute> query(String nameId, NameIDFormat format, String ... attributes) throws InvalidCertificateException, IOException {
        UserAttribute[] attrs = new UserAttribute[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            attrs[i] = UserAttribute.create(attributes[i], null);
        }
        return this.query(nameId, format, attrs);
    }

    public Collection<UserAttribute> query(String nameId, NameIDFormat format, UserAttribute ... attributes) throws InvalidCertificateException, IOException {
        OIOAttributeQuery q = OIOAttributeQuery.newQuery(this.idpMetadata.getAttributeQueryServiceLocation("urn:oasis:names:tc:SAML:2.0:bindings:SOAP"), nameId, format, this.spEntityId);
        for (UserAttribute attribute : attributes) {
            q.addAttribute(attribute.getName(), attribute.getFormat());
        }
        OIOAssertion res = q.executeQuery(this.client, this.credential, this.username, this.password, this.ignoreCertPath, this.idpMetadata.getValidCertificates(), !this.requireEncryption);
        ArrayList<UserAttribute> attrs = new ArrayList<UserAttribute>();
        for (AttributeStatement attrStatement : res.getAssertion().getAttributeStatements()) {
            for (Attribute attr : attrStatement.getAttributes()) {
                attrs.add(new UserAttribute(attr.getName(), attr.getFriendlyName(), AttributeUtil.extractAttributeValueValues(attr), attr.getNameFormat()));
            }
        }
        return attrs;
    }
}

