/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.bindings;

import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.bindings.BindingHandler;
import dk.itst.oiosaml.sp.model.OIOAuthnRequest;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.xml.security.credential.Credential;

public class ArtifactBindingHandler
implements BindingHandler {
    private static final Logger log = LoggerFactory.getLogger(ArtifactBindingHandler.class);
    public static final String VERSION = "$Id: ClientSSOEngine.java 2546 2008-04-11 13:29:25Z jre $";

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse response, Credential credential, OIOAuthnRequest authnRequest) throws IOException, ServletException {
        String requestURI = authnRequest.getRedirectURL(credential);
        if (log.isDebugEnabled()) {
            log.debug("redirectURL...:" + requestURI);
        }
        Audit.log(Operation.AUTHNREQUEST_REDIRECT_ARTIFACT, true, authnRequest.getID(), requestURI);
        response.sendRedirect(requestURI);
    }
}

