/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.bindings;

import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.bindings.BindingHandler;
import dk.itst.oiosaml.sp.model.OIOAuthnRequest;
import dk.itst.oiosaml.sp.service.util.HTTPUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.xml.security.credential.Credential;

public class RedirectBindingHandler
implements BindingHandler {
    private static final Logger log = LoggerFactory.getLogger(RedirectBindingHandler.class);

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect";
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse response, Credential credential, OIOAuthnRequest authnRequest) throws IOException, ServletException {
        String url = authnRequest.getRedirectURL(credential);
        log.debug("Issuing redirect to " + url);
        Audit.log(Operation.AUTHNREQUEST_REDIRECT, true, authnRequest.getID(), url);
        HTTPUtils.sendMetaRedirect(response, url, null, HTTPUtils.getFragmentCookie(req) == null);
    }
}

