/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.develmode;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.UserAssertion;
import dk.itst.oiosaml.sp.UserAssertionHolder;
import dk.itst.oiosaml.sp.UserAssertionImpl;
import dk.itst.oiosaml.sp.develmode.DevelMode;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.service.SAMLHttpServletRequest;
import dk.itst.oiosaml.sp.service.util.HTTPUtils;
import dk.itst.oiosaml.sp.util.AttributeUtil;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;

public class DevelModeImpl
implements DevelMode {
    private static final Logger log = LoggerFactory.getLogger(DevelModeImpl.class);

    @Override
    public void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain fc, Configuration conf) throws IOException, ServletException {
        if (req.getServletPath().equals(conf.getProperty("oiosaml-sp.servlet"))) {
            log.debug("Develmode: Request to SAML servlet, access granted");
            fc.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        UserAssertionHolder.set(null);
        UserAssertion ua = (UserAssertion)req.getSession().getAttribute("dk.itst.oiosaml.userassertion");
        if (ua == null) {
            String[] users = conf.getStringArray("oiosaml-sp.develmode.users");
            if (users == null || users.length == 0) {
                log.error("No users defined in properties. Set oiosaml-sp.develmode.users");
                res.setStatus(500);
                HTTPUtils.sendCacheHeaders(res);
                DevelModeImpl.render("nousers.vm", res, new HashMap());
                return;
            }
            if (users.length == 1) {
                ua = DevelModeImpl.selectUser(users[0], conf);
            } else {
                String selected = req.getParameter("__oiosaml_devel");
                if (selected == null || !Arrays.asList(users).contains(selected)) {
                    HTTPUtils.sendCacheHeaders(res);
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("users", users);
                    params.put("params", DevelModeImpl.buildParameterString(req.getParameterMap()));
                    DevelModeImpl.render("users.vm", res, params);
                    return;
                }
                HTTPUtils.sendCacheHeaders(res);
                ua = DevelModeImpl.selectUser(selected, conf);
                req.getSession().setAttribute("dk.itst.oiosaml.userassertion", (Object)ua);
                res.sendRedirect(req.getRequestURI() + "?" + DevelModeImpl.buildParameterString(req.getParameterMap()));
                return;
            }
        }
        if (ua != null) {
            req.getSession().setAttribute("dk.itst.oiosaml.userassertion", (Object)ua);
            UserAssertionHolder.set(ua);
            SAMLHttpServletRequest requestWrap = new SAMLHttpServletRequest(req, ua, "");
            fc.doFilter((ServletRequest)requestWrap, (ServletResponse)res);
            return;
        }
        log.error("No assertion found");
        res.sendError(500);
    }

    private static String buildParameterString(Map<String, String[]> params) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        try {
            for (Map.Entry<String, String[]> e : params.entrySet()) {
                if ("__oiosaml_devel".equals(e.getKey())) continue;
                for (String val : e.getValue()) {
                    sb.append(sep);
                    sep = "&";
                    sb.append(e.getKey()).append("=").append(URLEncoder.encode(val, "UTF-8"));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    private static UserAssertion selectUser(String user, Configuration conf) {
        Map<String, String[]> attributes = DevelModeImpl.getAttributes(user, conf);
        Assertion a = SAMLUtil.buildXMLObject(Assertion.class);
        a.setSubject(SAMLUtil.createSubject(user, "urn:test", new DateTime().plusHours(1)));
        AttributeStatement as = SAMLUtil.buildXMLObject(AttributeStatement.class);
        a.getAttributeStatements().add(as);
        for (Map.Entry<String, String[]> e : attributes.entrySet()) {
            Attribute attr = AttributeUtil.createAttribute(e.getKey(), e.getKey(), "");
            for (String val : e.getValue()) {
                attr.getAttributeValues().add(AttributeUtil.createAttributeValue(val));
            }
            as.getAttributes().add(attr);
        }
        return new UserAssertionImpl(new OIOAssertion(a));
    }

    private static Map<String, String[]> getAttributes(String user, Configuration conf) {
        String prefix = "oiosaml-sp.develmode." + user + ".";
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        Iterator i = conf.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith(prefix)) continue;
            String attr = key.substring(prefix.length());
            String[] value = conf.getStringArray(key);
            attributes.put(attr, value);
        }
        return attributes;
    }

    private static void render(String template, HttpServletResponse response, Map<String, ?> params) {
        VelocityContext ctx = new VelocityContext();
        for (Map.Entry<String, ?> e : params.entrySet()) {
            ctx.put(e.getKey(), e.getValue());
        }
        try {
            HTTPUtils.getEngine().mergeTemplate(template, "UTF-8", (Context)ctx, (Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

