/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.helper.DeveloperHelper;
import dk.itst.oiosaml.sp.model.OIOSamlObject;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.xml.XMLObject;

public class OIOAbstractResponse
extends OIOSamlObject {
    private final StatusResponseType response;

    public OIOAbstractResponse(StatusResponseType response) {
        super((XMLObject)response);
        this.response = response;
    }

    public boolean isIssuerOK(String issuer) {
        return this.response.getIssuer() != null && this.response.getIssuer().getValue() != null && this.response.getIssuer().getValue().equals(issuer);
    }

    public boolean isDestinationOK(String destination) {
        if (this.response.getDestination() == null) {
            return true;
        }
        return this.response.getDestination() != null && this.response.getDestination().equals(destination);
    }

    protected void validateResponse(String requestId, String expectedDestination, boolean allowPassive) {
        StatusCode is;
        String statusCode = this.response.getStatus().getStatusCode().getValue();
        if (!("urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode) || (is = this.response.getStatus().getStatusCode().getStatusCode()) != null && "urn:oasis:names:tc:SAML:2.0:status:NoPassive".equals(is.getValue()) && allowPassive)) {
            DeveloperHelper.log("The Identity Provider responded with a non-success message. The reason for this might be because the user who tried to login is not allowed to do so (something went wrong the users username/password, certificate, access rights, etc), or because something is wrong with the metadata configuration on the Identity Provider side.");
            String msg = this.response.getStatus().getStatusMessage() == null ? "" : this.response.getStatus().getStatusMessage().getMessage();
            throw new ValidationException("Got StatusCode " + statusCode + " should be " + "urn:oasis:names:tc:SAML:2.0:status:Success" + ". Message: " + msg);
        }
        if (!this.isDestinationOK(expectedDestination)) {
            throw new ValidationException("Wrong destination. Expected " + expectedDestination + ", was " + this.response.getDestination());
        }
        if (requestId != null && !requestId.equals(this.response.getInResponseTo())) {
            throw new ValidationException("Wrong InResponseTo. Expected " + requestId + ", was " + this.response.getInResponseTo());
        }
    }

    public String getInResponseTo() {
        return this.response.getInResponseTo();
    }

    public String getID() {
        return this.response.getID();
    }
}

