/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.NameIDFormat;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.OIORequest;
import dk.itst.oiosaml.sp.model.OIOResponse;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import dk.itst.oiosaml.sp.service.util.SOAPClient;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Subject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.credential.Credential;

public class OIOAttributeQuery
extends OIORequest {
    private static final Logger log = LoggerFactory.getLogger(OIOAttributeQuery.class);
    private final AttributeQuery request;

    public OIOAttributeQuery(AttributeQuery request) {
        super((RequestAbstractType)request);
        this.request = request;
    }

    public static OIOAttributeQuery newQuery(String endpointLocation, String nameId, NameIDFormat format, String spEntityId) {
        AttributeQuery q = SAMLUtil.buildXMLObject(AttributeQuery.class);
        q.setVersion(SAMLVersion.VERSION_20);
        Subject subject = SAMLUtil.createSubject(nameId, endpointLocation, new DateTime().plusMinutes(5));
        subject.getSubjectConfirmations().clear();
        subject.getNameID().setFormat(format.getFormat());
        q.setSubject(subject);
        q.setDestination(endpointLocation);
        q.setIssueInstant(new DateTime());
        q.setID(Utils.generateUUID());
        q.setIssuer(SAMLUtil.createIssuer(spEntityId));
        q.setConsent("urn:oasis:names:tc:SAML:2.0:consent:current-implicit");
        return new OIOAttributeQuery(q);
    }

    public void addAttribute(String name, String format) {
        Attribute a = SAMLUtil.buildXMLObject(Attribute.class);
        a.setName(name);
        a.setNameFormat(format);
        this.request.getAttributes().add(a);
    }

    public OIOAssertion executeQuery(SOAPClient client, Credential credential, String username, String password, boolean ignoreCertPath, Certificate idpCertificate, boolean allowUnencryptedAssertion) throws IOException {
        return this.executeQuery(client, credential, username, password, ignoreCertPath, Collections.singletonList(idpCertificate), allowUnencryptedAssertion);
    }

    public OIOAssertion executeQuery(SOAPClient client, Credential credential, String username, String password, boolean ignoreCertPath, Collection<? extends Certificate> idpCertificates, boolean allowUnencryptedAssertion) throws IOException {
        try {
            this.sign(credential);
            Audit.log(Operation.ATTRIBUTEQUERY, true, this.getID(), this.toXML());
            XMLObject res = client.wsCall(this, this.getDestination(), username, password, ignoreCertPath);
            if (!(res instanceof Response)) {
                throw new IllegalStateException("Received wrong type from IdP (expected Response): " + res);
            }
            OIOResponse oiores = new OIOResponse((Response)res);
            if (log.isDebugEnabled()) {
                log.debug("Received attribute query response: " + oiores.toXML());
            }
            Audit.log(Operation.ATTRIBUTEQUERY, false, this.getID(), oiores.toXML());
            oiores.validateResponse(null, idpCertificates, false);
            oiores.decryptAssertion(credential, allowUnencryptedAssertion);
            oiores.validateAssertionSignature(idpCertificates);
            return oiores.getAssertion();
        }
        catch (ValidationException e) {
            Audit.logError(Operation.ATTRIBUTEQUERY, false, this.getID(), (Throwable)e);
            throw e;
        }
    }
}

