/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.helper.DeveloperHelper;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.encryption.Decrypter;
import org.opensaml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.xml.encryption.ChainingEncryptedKeyResolver;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.encryption.InlineEncryptedKeyResolver;
import org.opensaml.xml.encryption.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.StaticKeyInfoCredentialResolver;

public class OIOEncryptedAssertion {
    private static final Logger log = LoggerFactory.getLogger(OIOEncryptedAssertion.class);
    private final EncryptedAssertion encrypted;

    public OIOEncryptedAssertion(EncryptedAssertion assertion) {
        this.encrypted = assertion;
        if (assertion.getEncryptedData().getType() == null) {
            assertion.getEncryptedData().setType("http://www.w3.org/2001/04/xmlenc#Element");
        }
    }

    public OIOAssertion decryptAssertion(Credential credential) {
        StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver(credential);
        ChainingEncryptedKeyResolver kekResolver = new ChainingEncryptedKeyResolver();
        kekResolver.getResolverChain().add(new InlineEncryptedKeyResolver());
        kekResolver.getResolverChain().add(new EncryptedElementTypeEncryptedKeyResolver());
        kekResolver.getResolverChain().add(new SimpleRetrievalMethodEncryptedKeyResolver());
        try {
            if (log.isDebugEnabled()) {
                log.debug("Assertion encrypted: " + this.encrypted);
            }
            Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)keyResolver, (EncryptedKeyResolver)kekResolver);
            decrypter.setRootInNewDocument(true);
            Assertion assertion = decrypter.decrypt(this.encrypted);
            if (log.isDebugEnabled()) {
                OIOAssertion res = new OIOAssertion(assertion);
                log.debug("Decrypted assertion: " + res.toXML());
            }
            return new OIOAssertion(assertion);
        }
        catch (DecryptionException e) {
            DeveloperHelper.log("Unable to decrypt assertion - this might be caused by using Oracle Java without installing the \"Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files\".");
            throw new ValidationException((Exception)((Object)e));
        }
    }
}

