/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import java.security.PublicKey;
import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xml.ElementExtensibleXMLObject;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OIOSamlObject {
    private static final Logger log = LoggerFactory.getLogger(OIOSamlObject.class);
    private final XMLObject obj;

    public OIOSamlObject(XMLObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        this.obj = obj;
    }

    public String toString() {
        return "Object: " + this.obj;
    }

    public String toXML() {
        Element e = SAMLUtil.marshallObject(this.obj);
        return XMLHelper.nodeToString((Node)e);
    }

    public void sign(Credential signingCredential) {
        Signature signature = SAMLUtil.buildXMLObject(Signature.class);
        if (!(this.obj instanceof SignableSAMLObject)) {
            throw new IllegalStateException("Object of type " + this.obj.getClass() + " is not signable");
        }
        this.obj.addNamespace(new Namespace("http://www.w3.org/2000/09/xmldsig#", "ds"));
        signature.setSigningCredential(signingCredential);
        try {
            SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)signingCredential, null, null);
        }
        catch (SecurityException e) {
            throw new WrappedException(Layer.BUSINESS, (Throwable)e);
        }
        ((SignableSAMLObject)this.obj).setSignature(signature);
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(this.obj);
            if (marshaller == null) {
                throw new RuntimeException("No marshaller registered for " + this.obj.getElementQName() + ", unable to marshall in preperation for signing");
            }
            marshaller.marshall(this.obj);
            Signer.signObject((Signature)signature);
        }
        catch (MarshallingException e) {
            log.error("Unable to marshall protocol message in preparation for signing", e);
            throw new WrappedException(Layer.BUSINESS, (Throwable)e);
        }
        catch (SignatureException e) {
            log.error("Unable to sign protocol message", e);
            throw new WrappedException(Layer.BUSINESS, (Throwable)e);
        }
    }

    public String toBase64() {
        Element element = SAMLUtil.marshallObject(this.obj);
        String xml = XMLHelper.nodeToString((Node)element);
        return Base64.encodeBytes((byte[])xml.getBytes(), (int)8);
    }

    public boolean hasSignature() {
        if (!(this.obj instanceof SignableSAMLObject)) {
            return false;
        }
        return ((SignableSAMLObject)this.obj).getSignature() != null;
    }

    public boolean verifySignature(PublicKey publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("Certificate cannot be null");
        }
        Signature signature = null;
        if (this.obj instanceof SignableSAMLObject) {
            SignableSAMLObject signableObject = (SignableSAMLObject)this.obj;
            signature = signableObject.getSignature();
        } else if (this.obj instanceof ElementExtensibleXMLObject) {
            signature = SAMLUtil.getFirstElement((ElementExtensibleXMLObject)this.obj, Signature.class);
        }
        if (signature == null) {
            log.warn("No signature present in object " + this.obj);
            return false;
        }
        SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
        try {
            profileValidator.validate(signature);
        }
        catch (Exception e) {
            log.warn("The signature does not meet the requirements indicated by the SAML profile of the XML signature", e);
            return false;
        }
        BasicX509Credential credential = new BasicX509Credential();
        credential.setPublicKey(publicKey);
        SignatureValidator validator = new SignatureValidator((Credential)credential);
        try {
            validator.validate(signature);
            return true;
        }
        catch (ValidationException e) {
            log.warn("The signature does not match the signature of the login site", e);
            return false;
        }
    }

    public String toSoapEnvelope() {
        Body body = SAMLUtil.buildXMLObject(Body.class);
        body.getUnknownXMLObjects().add(this.obj);
        Envelope envelope = SAMLUtil.buildXMLObject(Envelope.class);
        envelope.setBody(body);
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)envelope);
        try {
            Element e = marshaller.marshall((XMLObject)envelope);
            return XMLHelper.nodeToString((Node)e);
        }
        catch (MarshallingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
    }
}

