/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model.validation;

import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.validation.AssertionValidator;
import dk.itst.oiosaml.sp.model.validation.ClockSkewValidator;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Assertion;

public class BasicAssertionValidator
implements AssertionValidator {
    @Override
    public void validate(OIOAssertion assertion, String spEntityId, String spAssertionConsumerURL) throws ValidationException {
        Assertion a = assertion.getAssertion();
        if (a.getIssueInstant() == null) {
            throw new ValidationException("The assertion must contain a IssueInstant");
        }
        if (a.getIssuer() == null || a.getIssuer().getValue() == null) {
            throw new ValidationException("The assertion must contain an Issuer");
        }
        if (assertion.getSubjectNameIDValue() == null) {
            throw new ValidationException("The assertion must contain a Subject/NameID");
        }
        if (!assertion.getAudience().contains(spEntityId)) {
            throw new ValidationException("The assertion must contain the service provider " + spEntityId + " within the Audience list: " + assertion.getAudience());
        }
        DateTime conditionTimeNotOnOrAfter = assertion.getConditionTimeNotOnOrAfter();
        if (conditionTimeNotOnOrAfter == null || !ClockSkewValidator.isAfterNow(conditionTimeNotOnOrAfter)) {
            throw new ValidationException("Condition NotOnOrAfter is after now: " + conditionTimeNotOnOrAfter);
        }
        DateTime conditionTimeNotBefore = assertion.getConditionTimeNotBefore();
        if (conditionTimeNotBefore == null || !ClockSkewValidator.isBeforeNow(conditionTimeNotBefore)) {
            throw new ValidationException("Condition NotBefore is before now: " + conditionTimeNotBefore);
        }
    }
}

