/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model.validation;

import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.validation.BasicAssertionValidator;
import dk.itst.oiosaml.sp.model.validation.ClockSkewValidator;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnStatement;

public class OIOSAMLAssertionValidator
extends BasicAssertionValidator {
    @Override
    public void validate(OIOAssertion assertion, String spEntityId, String spAssertionConsumerURL) throws ValidationException {
        super.validate(assertion, spEntityId, spAssertionConsumerURL);
        Assertion a = assertion.getAssertion();
        DateTime confirmationTime = assertion.getConfirmationTime();
        if (confirmationTime == null || !ClockSkewValidator.isAfterNow(confirmationTime)) {
            throw new ValidationException("Subject Confirmation Data is expired: " + confirmationTime + " before " + new DateTime());
        }
        if (a.getAuthnStatements().size() != 1) {
            throw new ValidationException("The assertion must contain exactly one AuthnStatement. Was " + a.getAuthnStatements().size());
        }
        AuthnStatement authnStatement = (AuthnStatement)a.getAuthnStatements().get(0);
        if (assertion.getSessionIndex() == null) {
            throw new ValidationException("The assertion must contain a AuthnStatement@SessionIndex");
        }
        if (a.getAttributeStatements().size() != 1) {
            throw new ValidationException("The assertion must contain exactly one AttributeStatement. Contains " + a.getAttributeStatements().size());
        }
        if (a.getAuthzDecisionStatements().size() != 0) {
            throw new ValidationException("The assertion must not contain a AuthzDecisionStatement. Contains " + a.getAuthzDecisionStatements().size());
        }
        if (!assertion.checkRecipient(spAssertionConsumerURL)) {
            throw new ValidationException("The assertion must contain the recipient " + spAssertionConsumerURL);
        }
        if (authnStatement.getSessionNotOnOrAfter() != null && !ClockSkewValidator.isAfterNow(authnStatement.getSessionNotOnOrAfter())) {
            throw new ValidationException("The assertion must have a AuthnStatement@SessionNotOnOrAfter and it must not have expired. SessionNotOnOrAfter: " + authnStatement.getSessionNotOnOrAfter());
        }
    }
}

