/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.configuration.OIOSAMLBootstrap;
import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.security.CredentialRepository;
import dk.itst.oiosaml.sp.bindings.BindingHandlerFactory;
import dk.itst.oiosaml.sp.bindings.DefaultBindingHandlerFactory;
import dk.itst.oiosaml.sp.configuration.ConfigurationHandler;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.metadata.SPMetadata;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.session.SessionHandlerFactory;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.xml.security.credential.Credential;

public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 45789427728055436L;
    private static final Logger log = LoggerFactory.getLogger(DispatcherServlet.class);
    private transient IdpMetadata idpMetadata;
    private transient SPMetadata spMetadata;
    private Configuration configuration;
    private Credential credential;
    private final Map<String, SAMLHandler> handlers = new HashMap<String, SAMLHandler>();
    private boolean initialized = false;
    private transient VelocityEngine engine;
    private BindingHandlerFactory bindingHandlerFactory;
    private SessionHandlerFactory sessionHandlerFactory;
    private ServletContext servletContext;

    public final void init(ServletConfig config) throws ServletException {
        this.setHandler(new ConfigurationHandler(), "configure");
        this.servletContext = config.getServletContext();
        try {
            this.initServlet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.engine = new VelocityEngine();
        this.engine.setProperty("resource.loader", (Object)"classpath");
        this.engine.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            this.engine.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initServlet() throws WrappedException, NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        try {
            if (!this.initialized) {
                this.setConfiguration(SAMLConfigurationFactory.getConfiguration().getSystemConfiguration());
                this.handlers.putAll(Utils.getHandlers(this.configuration, this.servletContext));
                if (log.isDebugEnabled()) {
                    log.debug("Found handlers: " + this.handlers);
                }
                this.setHandler(new IndexHandler(), "");
                this.sessionHandlerFactory = SessionHandlerFactory.Factory.newInstance(this.configuration);
                this.sessionHandlerFactory.getHandler().resetReplayProtection(this.configuration.getInt("common.saml2.loggedinhandler.numusedassertionids"));
                if (this.configuration.getBoolean("oiosaml-sp.develmode", false)) {
                    log.warn("Running in devel mode");
                    return;
                }
                this.setBindingHandler(new DefaultBindingHandlerFactory());
                this.setIdPMetadata(IdpMetadata.getInstance());
                this.setSPMetadata(SPMetadata.getInstance());
                this.setCredential((Credential)new CredentialRepository().getCredential(SAMLConfigurationFactory.getConfiguration().getKeystore(), this.configuration.getString("oiosaml-sp.certificate.password")));
                this.initialized = true;
            }
        }
        catch (IllegalStateException e) {
            try {
                this.handlers.putAll(Utils.getHandlers(SAMLConfigurationFactory.getConfiguration().getCommonConfiguration(), this.servletContext));
            }
            catch (IOException e1) {
                log.error("Unable to load config", e);
            }
        }
    }

    protected final void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    protected final void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected final void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.initServlet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String action = req.getRequestURI().substring(req.getRequestURI().lastIndexOf("/") + 1);
        Audit.init(req);
        if (this.handlers.containsKey(action)) {
            try {
                SAMLHandler handler = this.handlers.get(action);
                SessionHandler sessionHandler = this.sessionHandlerFactory != null ? this.sessionHandlerFactory.getHandler() : null;
                RequestContext context = new RequestContext(req, res, this.idpMetadata, this.spMetadata, this.credential, this.configuration, sessionHandler, this.bindingHandlerFactory);
                handler.handleGet(context);
            }
            catch (Exception e) {
                Audit.logError(action, false, e);
                this.handleError(req, res, e);
            }
        } else {
            throw new UnsupportedOperationException(action + ", allowed: " + this.handlers.keySet());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.initServlet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String action = req.getRequestURI().substring(req.getRequestURI().lastIndexOf("/") + 1);
        Audit.init(req);
        if (this.handlers.containsKey(action)) {
            try {
                SAMLHandler handler = this.handlers.get(action);
                SessionHandler sessionHandler = this.sessionHandlerFactory != null ? this.sessionHandlerFactory.getHandler() : null;
                RequestContext context = new RequestContext(req, res, this.idpMetadata, this.spMetadata, this.credential, this.configuration, sessionHandler, this.bindingHandlerFactory);
                handler.handlePost(context);
            }
            catch (Exception e) {
                Audit.logError(action, false, e);
                this.handleError(req, res, e);
            }
        } else {
            throw new UnsupportedOperationException(action);
        }
    }

    public void setInitialized(boolean b) {
        this.initialized = b;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public final void setCredential(Credential credential) {
        this.credential = credential;
    }

    public final void setConfiguration(Configuration systemConfiguration) {
        this.configuration = systemConfiguration;
    }

    public final void setSPMetadata(SPMetadata metadata) {
        this.spMetadata = metadata;
    }

    public final void setIdPMetadata(IdpMetadata metadata) {
        this.idpMetadata = metadata;
    }

    public void setHandler(SAMLHandler handler, String dispatchPath) {
        this.handlers.put(dispatchPath, handler);
    }

    public void setBindingHandler(BindingHandlerFactory bindingHandlerFactory) {
        this.bindingHandlerFactory = bindingHandlerFactory;
    }

    public void setSessionHandlerFactory(SessionHandlerFactory sessionHandlerFactory) {
        this.sessionHandlerFactory = sessionHandlerFactory;
    }

    private void handleError(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException, IOException {
        String DEFAULT_MESSAGE = "Unable to validate SAML message!";
        log.error("Unable to validate Response", e);
        String err = null;
        if (this.configuration != null) {
            err = this.configuration.getString("oiosaml-sp.errors", null);
        }
        if (err != null) {
            if (this.configuration.getBoolean("oiosaml-sp.showerror", false)) {
                request.setAttribute("error", (Object)e.getMessage());
                request.setAttribute("exception", (Object)e);
            } else {
                request.setAttribute("error", (Object)DEFAULT_MESSAGE);
                request.setAttribute("exception", null);
            }
            request.getRequestDispatcher(err).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            VelocityContext ctx = new VelocityContext();
            if (this.configuration != null && this.configuration.getBoolean("oiosaml-sp.showerror", false)) {
                ctx.put("error", (Object)e.getMessage());
                ctx.put("exception", (Object)e);
            } else {
                ctx.put("error", (Object)DEFAULT_MESSAGE);
                ctx.put("exception", null);
            }
            response.setContentType("text/html");
            response.setStatus(500);
            try {
                this.engine.mergeTemplate("error.vm", "UTF-8", (Context)ctx, (Writer)response.getWriter());
            }
            catch (Exception e1) {
                log.error("Unable to render error template", e1);
                throw new ServletException((Throwable)e1);
            }
        }
    }

    public void destroy() {
        if (this.sessionHandlerFactory != null) {
            this.sessionHandlerFactory.close();
        }
        SessionHandlerFactory.Factory.close();
    }

    static {
        OIOSAMLBootstrap.init();
    }

    private class IndexHandler
    implements SAMLHandler {
        private IndexHandler() {
        }

        @Override
        public void handleGet(RequestContext context) throws ServletException, IOException {
            PrintWriter w = context.getResponse().getWriter();
            w.println("<html><head><title>SAML Endppoints</title></head><body><h1>SAML Endpoints</h1>");
            w.println("<ul>");
            for (Map.Entry e : DispatcherServlet.this.handlers.entrySet()) {
                w.println("<li><a href=\"");
                w.print((String)e.getKey());
                w.print("\">");
                w.print((String)e.getKey());
                w.print("</a>: ");
                w.print(e.getValue());
                w.println("</li>");
            }
            w.println("</ul>");
            w.println("</body></html>");
        }

        @Override
        public void handlePost(RequestContext context) throws ServletException, IOException {
        }
    }
}

