/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.AuthenticationHandler;
import dk.itst.oiosaml.sp.LogoutAuthenticationHandler;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.OIOLogoutRequest;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

public class LogoutHandler
implements SAMLHandler {
    private static final long serialVersionUID = 3843822219113371749L;
    public static final String VERSION = "$Id: LogoutHandler.java 2950 2008-05-28 08:22:34Z jre $";
    private static final Logger log = LoggerFactory.getLogger(LogoutHandler.class);

    @Override
    public void handleGet(RequestContext context) throws ServletException, IOException {
        HttpSession session = context.getSession();
        if (!context.getSessionHandler().isLoggedIn(session.getId())) {
            context.getSessionHandler().logOut(session);
            String homeUrl = context.getConfiguration().getString("oiosaml-sp.uri.home", context.getRequest().getContextPath());
            context.getResponse().sendRedirect(homeUrl);
            return;
        }
        OIOAssertion assertion = context.getSessionHandler().getAssertion(session.getId());
        String entityID = assertion.getAssertion().getIssuer().getValue();
        IdpMetadata.Metadata metadata = context.getIdpMetadata().getMetadata(entityID);
        OIOLogoutRequest lr = OIOLogoutRequest.buildLogoutRequest(session, metadata.getSingleLogoutServiceLocation(), context.getSpMetadata().getEntityID(), context.getSessionHandler());
        String redirectURL = lr.getRedirectRequestURL(context.getCredential());
        Audit.log(Operation.LOGOUTREQUEST, true, lr.getID(), lr.toXML());
        context.getSessionHandler().registerRequest(lr.getID(), metadata.getEntityID());
        context.getSessionHandler().logOut(session);
        LogoutHandler.invokeAuthenticationHandler(context);
        if (log.isDebugEnabled()) {
            log.debug("Redirect to..:" + redirectURL);
        }
        Audit.log(Operation.LOGOUT, assertion.getSubjectNameIDValue());
        SAMLConfigurationFactory.getConfiguration().getSameSiteSessionSynchronizer().linkSession(lr.getID(), session.getId());
        context.getResponse().sendRedirect(redirectURL);
    }

    @Override
    public void handlePost(RequestContext context) throws ServletException, IOException {
        throw new UnsupportedOperationException();
    }

    private static void invokeAuthenticationHandler(RequestContext ctx) {
        String handlerClass = ctx.getConfiguration().getString("oiosaml-sp.authenticationhandler", null);
        if (handlerClass != null) {
            log.debug("Authentication handler: " + handlerClass);
            AuthenticationHandler handler = (AuthenticationHandler)Utils.newInstance(ctx.getConfiguration(), "oiosaml-sp.authenticationhandler");
            if (handler instanceof LogoutAuthenticationHandler) {
                ((LogoutAuthenticationHandler)handler).userLoggedOut(ctx.getRequest(), ctx.getResponse());
            }
        } else {
            log.debug("No authentication handler configured");
        }
    }
}

