/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.configuration.OIOSAMLBootstrap;
import dk.itst.oiosaml.configuration.SAMLConfiguration;
import dk.itst.oiosaml.configuration.SAMLConfigurationFactory;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.UserAssertion;
import dk.itst.oiosaml.sp.UserAssertionHolder;
import dk.itst.oiosaml.sp.develmode.DevelMode;
import dk.itst.oiosaml.sp.develmode.DevelModeImpl;
import dk.itst.oiosaml.sp.metadata.CRLChecker;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.metadata.SPMetadata;
import dk.itst.oiosaml.sp.service.SAMLHttpServletRequest;
import dk.itst.oiosaml.sp.service.session.Request;
import dk.itst.oiosaml.sp.service.session.SessionCleaner;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.session.SessionHandlerFactory;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.security.BasicSecurityConfiguration;

public class SPFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SPFilter.class);
    private CRLChecker crlChecker = new CRLChecker();
    private boolean filterInitialized;
    private SAMLConfiguration conf;
    private String hostname;
    private SessionHandlerFactory sessionHandlerFactory;
    private AtomicBoolean cleanerRunning = new AtomicBoolean(false);
    private DevelMode develMode;

    public void destroy() {
        SessionCleaner.stopCleaner();
        this.crlChecker.stopChecker();
        if (this.sessionHandlerFactory != null) {
            this.sessionHandlerFactory.close();
        }
        SessionHandlerFactory.Factory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug("OIOSAML-J SP Filter invoked");
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new RuntimeException("Not supported operation...");
        }
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        Audit.init(servletRequest);
        if (!this.isFilterInitialized()) {
            try {
                Configuration config = SAMLConfigurationFactory.getConfiguration().getSystemConfiguration();
                this.setRuntimeConfiguration(config);
            }
            catch (IllegalStateException e) {
                request.getRequestDispatcher("/saml/configure").forward(request, response);
                return;
            }
        }
        SPFilter.ensureSignatureAlgorithm();
        if (this.conf.getSystemConfiguration().getBoolean("oiosaml-sp.develmode", false)) {
            log.warn("Running in debug mode, skipping regular filter");
            this.develMode.doFilter(servletRequest, (HttpServletResponse)response, chain, this.conf.getSystemConfiguration());
            return;
        }
        if (this.cleanerRunning.compareAndSet(false, true)) {
            SessionCleaner.startCleaner(this.sessionHandlerFactory.getHandler(), ((HttpServletRequest)request).getSession().getMaxInactiveInterval(), 30);
        }
        SessionHandler sessionHandler = this.sessionHandlerFactory.getHandler();
        if (servletRequest.getServletPath().equals(this.conf.getSystemConfiguration().getProperty("oiosaml-sp.servlet"))) {
            log.debug("Request to SAML servlet, access granted");
            chain.doFilter((ServletRequest)new SAMLHttpServletRequest(servletRequest, this.hostname, null), response);
            return;
        }
        HttpSession session = servletRequest.getSession();
        if (log.isDebugEnabled()) {
            log.debug("sessionId....:" + session.getId());
        }
        Boolean forceAuthn = false;
        if (request.getParameterMap().containsKey("forceAuthn")) {
            String forceAuthnAsString = request.getParameter("forceAuthn");
            forceAuthn = forceAuthnAsString.toLowerCase().equals("true");
        }
        if (sessionHandler.isLoggedIn(session.getId()) && session.getAttribute("dk.itst.oiosaml.userassertion") != null && !forceAuthn.booleanValue()) {
            this.validateAssuranceLevel(sessionHandler, session);
            this.validateProfile(sessionHandler, session);
            UserAssertion ua = (UserAssertion)session.getAttribute("dk.itst.oiosaml.userassertion");
            if (log.isDebugEnabled()) {
                log.debug("Everything is ok... Assertion: " + ua);
            }
            Audit.log(Operation.ACCESS, servletRequest.getRequestURI());
            try {
                UserAssertionHolder.set(ua);
                SAMLHttpServletRequest requestWrap = new SAMLHttpServletRequest(servletRequest, ua, this.hostname);
                chain.doFilter((ServletRequest)requestWrap, response);
                return;
            }
            finally {
                UserAssertionHolder.set(null);
            }
        }
        session.removeAttribute("dk.itst.oiosaml.userassertion");
        UserAssertionHolder.set(null);
        this.saveRequestAndGotoLogin((HttpServletResponse)response, servletRequest);
    }

    private void validateProfile(SessionHandler sessionHandler, HttpSession session) {
        String profile = this.conf.getSystemConfiguration().getString("oiosaml-sp.requested.profile", null);
        if (profile != null && !"https://data.gov.dk/eid/Person".equals(profile)) {
            if ("https://data.gov.dk/eid/Professional".equals(profile)) {
                boolean foundCvr = false;
                boolean foundOrgName = false;
                Assertion assertion = sessionHandler.getAssertion(session.getId()).getAssertion();
                for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
                    for (Attribute attribute : attributeStatement.getAttributes()) {
                        if ("https://data.gov.dk/model/core/eid/professional/cvr".equals(attribute.getName())) {
                            foundCvr = true;
                            continue;
                        }
                        if (!"https://data.gov.dk/model/core/eid/professional/orgName".equals(attribute.getName())) continue;
                        foundOrgName = true;
                    }
                }
                if (!foundCvr || !foundOrgName) {
                    sessionHandler.logOut(session);
                    throw new RuntimeException("Mandatory attributes for professional profile not present: " + (!foundCvr ? "https://data.gov.dk/model/core/eid/professional/cvr" : "") + " " + (!foundOrgName ? "https://data.gov.dk/model/core/eid/professional/orgName" : ""));
                }
            } else {
                log.warn("Unknown profile: " + profile);
            }
        }
    }

    private void validateAssuranceLevel(SessionHandler sessionHandler, HttpSession session) {
        int actualAssuranceLevel = sessionHandler.getAssertion(session.getId()).getAssuranceLevel();
        String actualNSISLevel = sessionHandler.getAssertion(session.getId()).getNSISLevel();
        int requiredAssuranceLevel = this.conf.getSystemConfiguration().getInt("oiosaml-sp.assurancelevel", 0);
        String requiredNSISLevel = this.conf.getSystemConfiguration().getString("oiosaml-sp.nsislevel", null);
        boolean valid = false;
        if (requiredAssuranceLevel == 0 && requiredNSISLevel == null) {
            valid = true;
        } else if (requiredAssuranceLevel > 0 && actualAssuranceLevel >= requiredAssuranceLevel) {
            valid = true;
        } else if (requiredNSISLevel != null && actualNSISLevel != null) {
            if (requiredNSISLevel.equals("https://data.gov.dk/concept/core/nsis/loa/High")) {
                if (actualNSISLevel.equals("High")) {
                    valid = true;
                }
            } else if (requiredNSISLevel.equals("https://data.gov.dk/concept/core/nsis/loa/Substantial")) {
                if (actualNSISLevel.equals("High") || actualNSISLevel.equals("Substantial")) {
                    valid = true;
                }
            } else if (requiredNSISLevel.equals("https://data.gov.dk/concept/core/nsis/loa/Low") && (actualNSISLevel.equals("High") || actualNSISLevel.equals("Substantial") || actualNSISLevel.equals("Low"))) {
                valid = true;
            }
        }
        if (!valid) {
            sessionHandler.logOut(session);
            String msg = requiredNSISLevel != null && requiredAssuranceLevel == 0 ? "NSIS level too low: " + actualNSISLevel + ", required: " + requiredNSISLevel : (requiredNSISLevel == null && requiredAssuranceLevel > 0 ? "Assurance level too low: " + actualAssuranceLevel + ", required: " + requiredAssuranceLevel : "Both NSIS level and Assurance level where too low: " + actualAssuranceLevel + " / " + actualNSISLevel + ", required: " + requiredAssuranceLevel + " / " + requiredNSISLevel);
            log.warn(msg);
            throw new RuntimeException(msg);
        }
    }

    protected void saveRequestAndGotoLogin(HttpServletResponse response, HttpServletRequest request) throws ServletException, IOException {
        SessionHandler sessionHandler = this.sessionHandlerFactory.getHandler();
        String relayState = sessionHandler.saveRequest(Request.fromHttpRequest(request));
        String protocol = this.conf.getSystemConfiguration().getString("oiosaml-sp.protocol", "saml20");
        String loginUrl = this.conf.getSystemConfiguration().getString("oiosaml-sp.servlet", "/saml");
        String protocolUrl = this.conf.getSystemConfiguration().getString("oiosaml-sp.protocol." + protocol);
        if (protocolUrl == null) {
            throw new RuntimeException("No protocol url configured for oiosaml-sp.protocol." + protocol);
        }
        loginUrl = loginUrl + protocolUrl;
        if (log.isDebugEnabled()) {
            log.debug("Redirecting to " + protocol + " login handler at " + loginUrl);
        }
        RequestDispatcher dispatch = request.getRequestDispatcher(loginUrl);
        dispatch.forward((ServletRequest)new SAMLHttpServletRequest(request, this.hostname, relayState), (ServletResponse)response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.conf = SAMLConfigurationFactory.getConfiguration();
        if (this.conf.isConfigured()) {
            try {
                Configuration config = SAMLConfigurationFactory.getConfiguration().getSystemConfiguration();
                if (config.getBoolean("oiosaml-sp.develmode", false)) {
                    this.develMode = new DevelModeImpl();
                    this.setConfiguration(config);
                    this.setFilterInitialized(true);
                    return;
                }
                this.setRuntimeConfiguration(config);
                this.setFilterInitialized(true);
                return;
            }
            catch (IllegalStateException e) {
                log.error("Unable to configure", e);
            }
        }
        this.setFilterInitialized(false);
    }

    private void setRuntimeConfiguration(Configuration conf) {
        this.restartCRLChecker(conf);
        this.setFilterInitialized(true);
        this.setConfiguration(conf);
        if (!IdpMetadata.getInstance().enableDiscovery()) {
            log.info("Discovery profile disabled, only one metadata file found");
        } else if (conf.getString("oiosaml-sp.discovery") == null) {
            throw new IllegalStateException("Discovery location cannot be null when discovery profile is active");
        }
        this.setHostname();
        this.sessionHandlerFactory = SessionHandlerFactory.Factory.newInstance(conf);
        this.sessionHandlerFactory.getHandler().resetReplayProtection(conf.getInt("common.saml2.loggedinhandler.numusedassertionids"));
        SPFilter.ensureSignatureAlgorithm();
        log.info("Home url: " + conf.getString("oiosaml-sp.uri.home"));
        log.info("Assurance level: " + conf.getInt("oiosaml-sp.assurancelevel"));
        log.info("SP entity ID: " + SPMetadata.getInstance().getEntityID());
        log.info("Base hostname: " + this.hostname);
    }

    private static void ensureSignatureAlgorithm() {
        Configuration localConfig = SAMLConfigurationFactory.getConfiguration().getSystemConfiguration();
        BasicSecurityConfiguration samlConfig = (BasicSecurityConfiguration)org.opensaml.Configuration.getGlobalSecurityConfiguration();
        samlConfig.registerSignatureAlgorithmURI("RSA", localConfig.getString("oiosaml-sp.signature.algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"));
    }

    private void setHostname() {
        String url = SPMetadata.getInstance().getDefaultAssertionConsumerService().getLocation();
        this.setHostname(url.substring(0, url.indexOf(47, 8)));
    }

    private void restartCRLChecker(Configuration config) {
        this.crlChecker.stopChecker();
        int period = config.getInt("oiosaml-sp.crl.period", 600);
        if (period > 0) {
            this.crlChecker.startChecker(period, IdpMetadata.getInstance(), config);
        } else {
            log.warn("Revocation check of IdP certificates has been disabled. All certificates including self signed certificates will be considered valid.");
            this.crlChecker.setAllCertificatesValid(IdpMetadata.getInstance());
        }
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setFilterInitialized(boolean b) {
        this.filterInitialized = b;
    }

    public boolean isFilterInitialized() {
        return this.filterInitialized;
    }

    public void setConfiguration(Configuration configuration) {
        SAMLConfigurationFactory.getConfiguration().setConfiguration(configuration);
        this.conf = SAMLConfigurationFactory.getConfiguration();
    }

    public void setSessionHandlerFactory(SessionHandlerFactory sessionHandlerFactory) {
        this.sessionHandlerFactory = sessionHandlerFactory;
    }

    public void setDevelMode(DevelMode develMode) {
        this.develMode = develMode;
    }

    static {
        OIOSAMLBootstrap.init();
    }
}

