/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Request
implements Serializable {
    private static final long serialVersionUID = 8582710873277995206L;
    private final String requestURI;
    private final String queryString;
    private final String method;
    private final Map<String, String[]> parameters;

    public Request(String requestURI, String queryString, String method, Map<String, String[]> parameters) {
        this.requestURI = requestURI;
        this.queryString = queryString == null ? null : queryString.replaceAll("forceAuthn=.*?($|[&;])", "");
        this.method = method;
        if (parameters != null) {
            parameters.remove("forceAuthn");
        }
        this.parameters = parameters;
    }

    public static Request fromHttpRequest(HttpServletRequest req) {
        HashMap<String, String[]> copy = new HashMap<String, String[]>();
        copy.putAll(req.getParameterMap());
        return new Request(req.getRequestURI(), req.getQueryString(), req.getMethod(), copy);
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }
}

