/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.session;

import dk.itst.oiosaml.sp.service.session.SameSiteSessionSynchronizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionCopyListener
implements HttpSessionListener,
SameSiteSessionSynchronizer {
    private static Map<String, HttpSession> sessions = new HashMap<String, HttpSession>();
    private static Map<String, String> sessionLinks = new HashMap<String, String>();

    public void sessionCreated(HttpSessionEvent event) {
        SessionCopyListener.add(event.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        SessionCopyListener.remove(event.getSession());
    }

    @Override
    public HttpSession getSession(String requestId) {
        HttpSession session;
        String sessionId = sessionLinks.get(requestId);
        if (sessionId != null && (session = sessions.get(sessionId)) != null) {
            return session;
        }
        return null;
    }

    @Override
    public void linkSession(String requestId, String sessionId) {
        sessionLinks.put(requestId, sessionId);
    }

    private static synchronized void add(HttpSession session) {
        sessions.put(session.getId(), session);
    }

    private static synchronized void remove(HttpSession session) {
        sessions.remove(session.getId());
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : sessionLinks.keySet()) {
            if (!sessionLinks.get(key).equals(session.getId())) continue;
            toRemove.add(key);
            return;
        }
        for (String key : toRemove) {
            sessionLinks.remove(key);
        }
    }
}

