/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.session;

import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.session.SessionHandlerFactory;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionDestroyListener
implements HttpSessionListener {
    private static final Logger logger = LoggerFactory.getLogger(SessionDestroyListener.class);

    public void sessionCreated(HttpSessionEvent arg0) {
        logger.debug("Session: " + arg0);
    }

    public void sessionDestroyed(HttpSessionEvent e) {
        SessionHandlerFactory sf = SessionHandlerFactory.Factory.newInstance(null);
        if (sf == null) {
            logger.warn("No SessionHandler configured, skipping session destroy");
            return;
        }
        if (e.getSession() == null) {
            return;
        }
        SessionHandler handler = sf.getHandler();
        boolean loggedIn = handler.isLoggedIn(e.getSession().getId());
        logger.debug("User logged in: " + loggedIn);
        if (loggedIn) {
            OIOAssertion assertion = handler.getAssertion(e.getSession().getId());
            Audit.logSystem(e.getSession().getId(), assertion.getID(), Operation.TIMEOUT, assertion.getSubjectNameIDValue());
            handler.logOut(e.getSession().getId());
        } else {
            logger.debug("Session destroyed without saml assertion");
        }
    }
}

