/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.session;

import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.service.session.Request;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.session.TimeOutWrapper;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.map.LRUMap;
import org.opensaml.saml2.core.Issuer;

public class SingleVMSessionHandler
implements SessionHandler {
    private static final Logger log = LoggerFactory.getLogger(SingleVMSessionHandler.class);
    private final Map<String, TimeOutWrapper<OIOAssertion>> sessionMap = new ConcurrentHashMap<String, TimeOutWrapper<OIOAssertion>>();
    private final Map<String, TimeOutWrapper<String>> sessionIndexMap = new ConcurrentHashMap<String, TimeOutWrapper<String>>();
    private final Map<String, TimeOutWrapper<String>> requestIds = new ConcurrentHashMap<String, TimeOutWrapper<String>>();
    private final Map<String, TimeOutWrapper<Request>> requests = new ConcurrentHashMap<String, TimeOutWrapper<Request>>();
    private Map<String, String> usedAssertionIds = new LRUMap(10000);

    @Override
    public synchronized void setAssertion(String sessionId, OIOAssertion assertion) throws IllegalArgumentException {
        Issuer issuer = assertion.getAssertion().getIssuer();
        String key = (issuer != null ? issuer.getValue() : "unknown") + ":" + assertion.getAssertion().getID();
        if (this.usedAssertionIds.containsKey(key)) {
            throw new IllegalArgumentException("Assertion ID begin replayed: " + key);
        }
        this.usedAssertionIds.put(key, assertion.getAssertion().getID());
        this.sessionMap.put(sessionId, new TimeOutWrapper<OIOAssertion>(assertion));
        String sessionIndex = assertion.getSessionIndex();
        if (sessionIndex != null) {
            this.sessionIndexMap.remove(sessionIndex);
            this.sessionIndexMap.put(sessionIndex, new TimeOutWrapper<String>(sessionId));
        }
    }

    @Override
    public boolean isLoggedIn(String sessionId) {
        OIOAssertion ass = this.getAssertion(sessionId);
        return ass != null && !ass.hasSessionExpired();
    }

    @Override
    public void logOut(HttpSession session) {
        this.removeAssertion(session.getId());
        session.removeAttribute("dk.itst.oiosaml.userassertion");
    }

    private void removeAssertion(String sessionId) {
        String sessionIndex;
        OIOAssertion ass;
        TimeOutWrapper<OIOAssertion> tow = this.sessionMap.remove(sessionId);
        if (tow != null && (ass = tow.getObject()) != null && (sessionIndex = ass.getSessionIndex()) != null) {
            this.sessionIndexMap.remove(sessionIndex);
        }
    }

    @Override
    public void logOut(String sessionId) {
        this.removeAssertion(sessionId);
    }

    @Override
    public synchronized OIOAssertion getAssertion(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        if (!this.sessionMap.containsKey(sessionId)) {
            return null;
        }
        TimeOutWrapper<OIOAssertion> tow = this.sessionMap.get(sessionId);
        tow.setAccesstime();
        return tow.getObject();
    }

    @Override
    public String getRelatedSessionId(String sessionIndex) {
        if (this.sessionIndexMap.containsKey(sessionIndex)) {
            return this.sessionIndexMap.get(sessionIndex).getObject();
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void registerRequest(String id, String receiverEntityID) {
        if (log.isDebugEnabled()) {
            log.debug("Registered id " + id + " for " + receiverEntityID + "(size: " + this.requestIds.size() + ")");
        }
        this.requestIds.put(id, new TimeOutWrapper<String>(receiverEntityID));
    }

    @Override
    public String removeEntityIdForRequest(String id) {
        TimeOutWrapper<String> tow;
        if (log.isDebugEnabled()) {
            log.debug("Removing id " + id);
        }
        if ((tow = this.requestIds.remove(id)) == null) {
            throw new IllegalArgumentException("Request id " + id + " is unknown");
        }
        if (log.isDebugEnabled()) {
            log.debug("Entity for request " + id + ": " + tow.getObject());
        }
        return tow.getObject();
    }

    @Override
    public void cleanup(long requestIdsCleanupDelay, long sessionCleanupDelay) {
        this.cleanup(this.sessionMap, sessionCleanupDelay, "Session ");
        this.cleanup(this.requestIds, requestIdsCleanupDelay, "Request ");
        this.cleanup(this.sessionIndexMap, sessionCleanupDelay, "SessionIndex ");
        this.cleanup(this.requests, sessionCleanupDelay, "Request ");
    }

    private <E, T> void cleanup(Map<E, TimeOutWrapper<T>> map, long cleanupDelay, String msg) {
        if (log.isDebugEnabled()) {
            log.debug(this.hashCode() + " Running cleanup timer on " + map);
        }
        for (E key : map.keySet()) {
            TimeOutWrapper<T> tow = map.get(key);
            if (!tow.isExpired(cleanupDelay)) continue;
            log.debug("Expiring " + tow);
            if (tow.getObject() instanceof OIOAssertion) {
                OIOAssertion a = (OIOAssertion)tow.getObject();
                Audit.logSystem(null, a.getID(), Operation.TIMEOUT, a.getSubjectNameIDValue());
            }
            map.remove(key);
        }
    }

    @Override
    public void resetReplayProtection(int maxNum) {
        this.usedAssertionIds = new LRUMap(maxNum);
    }

    @Override
    public String saveRequest(Request request) {
        String state = Utils.generateUUID();
        this.requests.put(state, new TimeOutWrapper<Request>(request));
        return state;
    }

    @Override
    public Request getRequest(String state) throws IllegalArgumentException {
        TimeOutWrapper<Request> request = this.requests.remove(state);
        if (request == null) {
            log.error("No request for state " + state);
            return null;
        }
        return request.getObject();
    }
}

