/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.util;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.common.SOAPException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.OIOSamlObject;
import dk.itst.oiosaml.sp.service.util.DummySSLSocketFactory;
import dk.itst.oiosaml.sp.service.util.SOAPClient;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.io.IOUtils;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.soap.soap11.Fault;
import org.opensaml.xml.ElementExtensibleXMLObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Node;

public class HttpSOAPClient
implements SOAPClient {
    private static final String START_SOAP_ENVELOPE = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><soapenv:Header/><soapenv:Body>";
    private static final String END_SOAP_ENVELOPE = "</soapenv:Body></soapenv:Envelope>";
    private static final Logger log = LoggerFactory.getLogger(HttpSOAPClient.class);

    @Override
    public XMLObject wsCall(OIOSamlObject obj, String location, String username, String password, boolean ignoreCertPath) throws IOException {
        return (XMLObject)this.wsCall(location, username, password, ignoreCertPath, obj.toSoapEnvelope(), "http://www.oasis-open.org/committees/security").getBody().getUnknownXMLObjects().get(0);
    }

    @Override
    public Envelope wsCall(XMLObject obj, String location, String username, String password, boolean ignoreCertPath) throws IOException {
        String xml = XMLHelper.nodeToString((Node)SAMLUtil.marshallObject(obj));
        xml = START_SOAP_ENVELOPE + xml.substring(xml.indexOf("?>") + 2) + END_SOAP_ENVELOPE;
        return this.wsCall(location, username, password, ignoreCertPath, xml, "http://www.oasis-open.org/committees/security");
    }

    @Override
    public Envelope wsCall(String location, String username, String password, boolean ignoreCertPath, String xml, String soapAction) throws IOException, SOAPException {
        HttpURLConnection c;
        URI serviceLocation;
        try {
            serviceLocation = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid uri for artifact resolve: " + location);
        }
        if (log.isDebugEnabled()) {
            log.debug("serviceLocation..:" + serviceLocation);
        }
        if (log.isDebugEnabled()) {
            log.debug("SOAP Request: " + xml);
        }
        if ((c = (HttpURLConnection)serviceLocation.toURL().openConnection()) instanceof HttpsURLConnection) {
            HttpsURLConnection sc = (HttpsURLConnection)c;
            if (ignoreCertPath) {
                sc.setSSLSocketFactory(new DummySSLSocketFactory());
                sc.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
        }
        c.setAllowUserInteraction(false);
        c.setDoInput(true);
        c.setDoOutput(true);
        c.setFixedLengthStreamingMode(xml.getBytes("UTF-8").length);
        c.setRequestMethod("POST");
        c.setReadTimeout(20000);
        c.setConnectTimeout(30000);
        HttpSOAPClient.addContentTypeHeader(xml, c);
        c.addRequestProperty("SOAPAction", "\"" + (soapAction == null ? "" : soapAction) + "\"");
        if (username != null && password != null) {
            c.addRequestProperty("Authorization", "Basic " + Base64.encodeBytes((byte[])(username + ":" + password).getBytes(), (int)8));
        }
        OutputStream outputStream = c.getOutputStream();
        IOUtils.write((String)xml, (OutputStream)outputStream, (String)"UTF-8");
        outputStream.flush();
        outputStream.close();
        if (c.getResponseCode() == 200) {
            XMLObject res;
            Envelope envelope;
            InputStream inputStream = c.getInputStream();
            String result = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
            if (log.isDebugEnabled()) {
                log.debug("Server SOAP response: " + result);
            }
            if (SAMLUtil.getFirstElement((ElementExtensibleXMLObject)(envelope = (Envelope)(res = SAMLUtil.unmarshallElementFromString(result))).getBody(), Fault.class) != null) {
                log.warn("Result has soap11:Fault, but server returned 200 OK. Treating as error, please fix the server");
                throw new SOAPException(c.getResponseCode(), result);
            }
            return envelope;
        }
        log.debug("Response code: " + c.getResponseCode());
        InputStream inputStream = c.getErrorStream();
        String result = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        inputStream.close();
        if (log.isDebugEnabled()) {
            log.debug("Server SOAP fault: " + result);
        }
        throw new SOAPException(c.getResponseCode(), result);
    }

    private static void addContentTypeHeader(String xml, HttpURLConnection c) {
        String soapVersion = Utils.getSoapVersion(xml);
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapVersion)) {
            c.addRequestProperty("Content-Type", "text/xml; charset=utf-8");
        } else if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersion)) {
            c.addRequestProperty("Content-Type", "application/soap+xml; charset=utf-8");
        } else {
            throw new UnsupportedOperationException("SOAP version " + soapVersion + " not supported");
        }
    }
}

