/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.util;

import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import java.lang.reflect.Constructor;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.Configuration;
import org.opensaml.xml.util.Base64;

public final class Utils {
    public static final String VERSION = "$Id: Utils.java 3197 2008-07-25 07:47:33Z jre $";
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final String[] SOAP_VERSIONS = new String[]{"http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope"};

    public static String makeXML(String param) {
        String xml = param;
        if (xml != null && !"".equals(xml)) {
            xml = xml.replaceAll("><", ">\n<");
            xml = xml.replaceAll("<", "&lt;");
            xml = xml.replaceAll(">", "&gt;");
            xml = xml.replaceAll("\n", "<br />");
        }
        return xml;
    }

    public static String htmlEntityEncode(String s) {
        StringBuilder buf = new StringBuilder();
        int len = s == null ? -1 : s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                buf.append(c);
                continue;
            }
            buf.append("&#" + c + ";");
        }
        return buf.toString();
    }

    public static boolean verifySignature(String signature, String queryString, String queryParameter, PublicKey publicKey) {
        if (log.isDebugEnabled()) {
            log.debug("signature..:" + signature);
        }
        if (signature == null) {
            return false;
        }
        byte[] buffer = Base64.decode((String)signature);
        String data = Utils.parseSignedQueryString(queryString, queryParameter);
        if (log.isDebugEnabled()) {
            log.debug("data.......:" + data);
        }
        if (log.isDebugEnabled()) {
            log.debug("Verifying Signature...");
        }
        return Utils.verifySignature(data.getBytes(), publicKey, buffer);
    }

    public static boolean verifySignature(byte[] data, PublicKey key, byte[] sig) {
        if (log.isDebugEnabled()) {
            log.debug("data...:" + new String(data));
            log.debug("sig....:" + new String(sig));
            log.debug("key....:" + key.toString());
        }
        try {
            Signature signer2;
            boolean valid = false;
            try {
                signer2 = Signature.getInstance("SHA256withRSA");
                signer2.initVerify(key);
                signer2.update(data);
                valid = signer2.verify(sig);
            }
            catch (Exception signer2) {
                // empty catch block
            }
            if (!valid) {
                signer2 = Signature.getInstance("SHA1withRSA");
                signer2.initVerify(key);
                signer2.update(data);
                valid = signer2.verify(sig);
            }
            return valid;
        }
        catch (InvalidKeyException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        catch (SignatureException e) {
            log.error("Failed to verify signature", e);
            return false;
        }
    }

    public static String beautifyAndHtmlXML(String xml, String split) {
        return Utils.makeXML(Utils.beautifyXML(xml, split));
    }

    public static String beautifyXML(String xml, String split) {
        String s = "";
        if (split != null) {
            s = ".:split:.";
        }
        if (xml == null || "".equals(xml)) {
            return xml;
        }
        StringBuffer result = new StringBuffer();
        String[] results = xml.split("<");
        for (int i = 1; i < results.length; ++i) {
            results[i] = "<" + results[i].trim();
            if (results[i].endsWith("/>")) {
                result.append(results[i]).append(s);
                continue;
            }
            if (results[i].startsWith("</")) {
                result.append(results[i]).append(s);
                continue;
            }
            if (results[i].endsWith(">")) {
                result.append(results[i]).append(s);
                continue;
            }
            result.append(results[i]);
        }
        if (split == null) {
            return result.toString().trim();
        }
        StringBuilder newResult = new StringBuilder();
        String ident = "";
        results = result.toString().split(s);
        for (int i = 0; i < results.length; ++i) {
            if (results[i].startsWith("</")) {
                ident = ident.substring(split.length());
            }
            newResult.append(ident).append(results[i]).append("\n");
            if (results[i].startsWith("<!") || results[i].startsWith("<?") || results[i].indexOf("</") != -1 || results[i].indexOf("/>") != -1) continue;
            ident = ident + split;
        }
        return newResult.toString();
    }

    public static String generateUUID() {
        return "_" + UUID.randomUUID().toString();
    }

    public static String getSoapVersion(String xml) {
        for (int i = 0; i < SOAP_VERSIONS.length; ++i) {
            int idx = xml.indexOf(SOAP_VERSIONS[i]);
            if (idx <= -1) continue;
            String prefix = Utils.getPrefix(xml, idx);
            int start = xml.lastIndexOf(60, idx);
            if (xml.lastIndexOf((prefix = prefix == null ? "<" : "<" + prefix + ":") + "Envelope", idx) < start) continue;
            return SOAP_VERSIONS[i];
        }
        return null;
    }

    private static String getPrefix(String xml, int idx) {
        if (idx > -1) {
            String prefix = xml.substring(xml.lastIndexOf(32, idx) + 1, idx);
            prefix = prefix.startsWith("xmlns:") ? prefix.substring(6, prefix.lastIndexOf(61)).trim() : null;
            return prefix;
        }
        return null;
    }

    public static Object newInstance(Configuration cfg, String property) {
        String name = cfg.getString(property);
        if (name == null) {
            throw new IllegalArgumentException("Property " + property + " has not been set");
        }
        try {
            Class<?> c = Class.forName(name);
            return c.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instance of " + name, e);
        }
    }

    public static Map<String, SAMLHandler> getHandlers(Configuration config, ServletContext servletContext) {
        HashMap<String, SAMLHandler> handlers = new HashMap<String, SAMLHandler>();
        Iterator i = config.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith("oiosaml-sp.protocol.endpoints.")) continue;
            log.debug("Checking " + key);
            try {
                SAMLHandler instance;
                Class<?> c = Class.forName(config.getString(key));
                try {
                    Constructor<?> constructor = c.getConstructor(Configuration.class);
                    instance = (SAMLHandler)constructor.newInstance(config);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Constructor<?> constructor = c.getConstructor(ServletContext.class);
                        instance = (SAMLHandler)constructor.newInstance(servletContext);
                    }
                    catch (NoSuchMethodException ex) {
                        instance = (SAMLHandler)c.newInstance();
                    }
                }
                handlers.put(key.substring(key.lastIndexOf(46) + 1), instance);
            }
            catch (Exception e) {
                log.error("Unable to instantiate " + key + ": " + config.getString(key), e);
                throw new RuntimeException(e);
            }
        }
        return handlers;
    }

    public static String parseSignedQueryString(String queryString, String queryParameter) {
        StringBuilder s = new StringBuilder();
        String samlRequestOrResponse = Utils.getParameter(queryParameter, queryString);
        String relayState = Utils.getParameter("RelayState", queryString);
        String sigAlg = Utils.getParameter("SigAlg", queryString);
        s.append(queryParameter);
        s.append("=");
        s.append(samlRequestOrResponse);
        if (relayState != null) {
            s.append("&");
            s.append("RelayState");
            s.append("=");
            s.append(relayState);
        }
        s.append("&");
        s.append("SigAlg");
        s.append("=");
        s.append(sigAlg);
        return s.toString();
    }

    public static String getParameter(String name, String url) {
        String[] parts;
        int qpos = url.indexOf(63) + 1;
        for (String part : parts = url.substring(qpos).split("&")) {
            int pos = part.indexOf(61);
            String key = part.substring(0, pos);
            if (!name.equals(key)) continue;
            return part.substring(pos + 1);
        }
        return null;
    }
}

