/*
 * Decompiled with CFR 0.152.
 */
package dk.nodes.data.lib;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dk.nodes.data.lib.AnnotatedClass;
import java.io.IOException;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class CodeGenerator {
    private static final String SUFFIX = "Manager";

    private static String getPackageName(Elements elementUtils, AnnotatedClass annotatedClass) {
        PackageElement pkg = elementUtils.getPackageOf(annotatedClass.getTypeElement());
        String packageName = pkg.isUnnamed() ? null : pkg.getQualifiedName().toString();
        return packageName;
    }

    public static void generateSerializedFileCode(Elements elementUtils, Filer filer, AnnotatedClass annotatedClass) throws IOException {
        String generatedClassName = annotatedClass.getTypeElement().getSimpleName() + SUFFIX;
        String packageName = CodeGenerator.getPackageName(elementUtils, annotatedClass);
        MethodSpec saveMethod = MethodSpec.methodBuilder((String)"save").addJavadoc("Writes object to openFileOutput().\n", new Object[0]).addParameter((TypeName)ClassName.get((String)packageName, (String)annotatedClass.getTypeElement().getSimpleName().toString(), (String[])new String[0]), "data", new Modifier[0]).addCode("try {\n\tfos = context.openFileOutput(\"" + annotatedClass.getKey() + "\", Context.MODE_PRIVATE);\n" + "\tos = new ObjectOutputStream(fos);\n" + "\tos.writeObject(data);\n" + "\tos.close();\n" + "} catch(Exception e) {\n" + "\t// Empty\n" + "}\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        MethodSpec loadMethod = MethodSpec.methodBuilder((String)"load").returns((TypeName)ClassName.get((TypeElement)annotatedClass.getTypeElement())).addJavadoc("Reads object from openFileInput().\n", new Object[0]).addJavadoc("@return " + annotatedClass.getTypeElement().getSimpleName() + " In case an exception is thrown, returns {@code new " + annotatedClass.getTypeElement().getSimpleName() + "()}\n", new Object[0]).addCode("try {\n\tfis = context.openFileInput(\"" + annotatedClass.getKey() + "\");\n" + "\tis = new ObjectInputStream(fis);\n" + "\tObject input = is.readObject();\n" + "\tis.close();\n" + "\treturn (" + annotatedClass.getTypeElement().getSimpleName() + ") input;\n" + "} catch(Exception e) {\n" + "\treturn new " + annotatedClass.getTypeElement().getSimpleName() + "();\n" + "}\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        TypeSpec manager = TypeSpec.classBuilder((String)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField((TypeName)ClassName.get((String)"java.io", (String)"FileInputStream", (String[])new String[0]), "fis", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"ObjectInputStream", (String[])new String[0]), "is", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"FileOutputStream", (String[])new String[0]), "fos", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"ObjectOutputStream", (String[])new String[0]), "os", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), "context", new Modifier[]{Modifier.PRIVATE}).addMethod(loadMethod).addMethod(saveMethod).addMethod(CodeGenerator.generateContextConstructor()).build();
        JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)manager).build();
        file.writeTo(filer);
    }

    public static void generateSerializedPrefsCode(Elements elementUtils, Filer filer, AnnotatedClass annotatedClass) throws IOException {
        String generatedClassName = annotatedClass.getTypeElement().getSimpleName() + SUFFIX;
        String packageName = CodeGenerator.getPackageName(elementUtils, annotatedClass);
        MethodSpec saveMethod = MethodSpec.methodBuilder((String)"save").addJavadoc("Writes object to SharedPreferences.\n", new Object[0]).addParameter((TypeName)ClassName.get((String)packageName, (String)annotatedClass.getTypeElement().getSimpleName().toString(), (String[])new String[0]), "data", new Modifier[0]).addCode("try {\n\tsharedPreferences = context.getSharedPreferences(\"appprefs\", Context.MODE_PRIVATE);\n\tbos = new ByteArrayOutputStream();\n\tos = new ObjectOutputStream( bos );\n\tos.writeObject(data);\n\tString encodedString = Base64.encodeToString(bos.toByteArray(), Base64.DEFAULT);\n\tSharedPreferences.Editor editor = sharedPreferences.edit();\n\teditor.putString(\"" + annotatedClass.getKey() + "\", encodedString);\n" + "\teditor.commit();\n" + "\tbos.close();\n" + "} catch(Exception e) {\n" + "\t// Empty\n" + "}\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        MethodSpec loadMethod = MethodSpec.methodBuilder((String)"load").returns((TypeName)ClassName.get((TypeElement)annotatedClass.getTypeElement())).addJavadoc("Reads object from SharedPreferences.\n", new Object[0]).addJavadoc("@return " + annotatedClass.getTypeElement().getSimpleName() + " In case an exception is thrown, returns {@code new " + annotatedClass.getTypeElement().getSimpleName() + "()}\n", new Object[0]).addCode("try {\n\tsharedPreferences = context.getSharedPreferences(\"appprefs\", Context.MODE_PRIVATE);\n\tString inputString = sharedPreferences.getString(\"" + annotatedClass.getKey() + "\", \"nothing\");\n" + "\tbyte[] byteData = Base64.decode(inputString, Base64.DEFAULT);\n" + "\tbis = new ByteArrayInputStream(byteData);\n" + "\tis = new ObjectInputStream(bis);\n" + "\tObject input = is.readObject();\n" + "\tbis.close();\n" + "\treturn (" + annotatedClass.getTypeElement().getSimpleName() + ") input;\n" + "} catch(Exception e) {\n" + "\treturn new " + annotatedClass.getTypeElement().getSimpleName() + "();\n" + "}\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        TypeSpec manager = TypeSpec.classBuilder((String)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField((TypeName)ClassName.get((String)"java.io", (String)"ObjectInputStream", (String[])new String[0]), "is", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"ObjectOutputStream", (String[])new String[0]), "os", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"ByteArrayInputStream", (String[])new String[0]), "bis", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"ByteArrayOutputStream", (String[])new String[0]), "bos", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"android.util", (String)"Base64", (String[])new String[0]), "base64", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"android.content", (String)"SharedPreferences", (String[])new String[0]), "sharedPreferences", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), "context", new Modifier[]{Modifier.PRIVATE}).addMethod(loadMethod).addMethod(saveMethod).addMethod(CodeGenerator.generateContextConstructor()).build();
        JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)manager).build();
        file.writeTo(filer);
    }

    public static void generateGsonPrefsCode(Elements elementUtils, Filer filer, AnnotatedClass annotatedClass) throws IOException {
        String generatedClassName = annotatedClass.getTypeElement().getSimpleName() + SUFFIX;
        String packageName = CodeGenerator.getPackageName(elementUtils, annotatedClass);
        MethodSpec saveMethod = MethodSpec.methodBuilder((String)"save").addJavadoc("Writes object to SharedPreferences.\n", new Object[0]).addParameter((TypeName)ClassName.get((String)packageName, (String)annotatedClass.getTypeElement().getSimpleName().toString(), (String[])new String[0]), "data", new Modifier[0]).addCode("try {\n\tgson = new Gson();\n\tsharedPreferences = context.getSharedPreferences(\"appprefs\", Context.MODE_PRIVATE);\n\tString s = gson.toJson(object);\n\tSharedPreferences.Editor editor = sharedPreferences.edit();\n\teditor.putString(\"" + annotatedClass.getKey() + "\", s);\n" + "\teditor.commit();\n" + "} catch(Exception e) {\n" + "\t// Empty\n" + "}\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        MethodSpec loadMethod = MethodSpec.methodBuilder((String)"load").returns((TypeName)ClassName.get((TypeElement)annotatedClass.getTypeElement())).addJavadoc("Reads object from SharedPreferences.\n", new Object[0]).addJavadoc("@return " + annotatedClass.getTypeElement().getSimpleName() + " In case an exception is thrown, returns {@code new " + annotatedClass.getTypeElement().getSimpleName() + "()}\n", new Object[0]).addCode("try {\n\tgson = new Gson();\n\tsharedPreferences = context.getSharedPreferences(\"appprefs\", Context.MODE_PRIVATE);\n\tString inputString = sharedPreferences.getString(\"" + annotatedClass.getKey() + "\", \"nothing\");\n" + "\tObject input = gson.fromJson(inputString, " + annotatedClass.getTypeElement().getSimpleName() + ".class);\n" + "\treturn (" + annotatedClass.getTypeElement().getSimpleName() + ") input;\n" + "} catch(Exception e) {\n" + "\treturn new " + annotatedClass.getTypeElement().getSimpleName() + "();\n" + "}\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        TypeSpec manager = TypeSpec.classBuilder((String)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField((TypeName)ClassName.get((String)"com.google.gson", (String)"Gson", (String[])new String[0]), "gson", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"android.content", (String)"SharedPreferences", (String[])new String[0]), "sharedPreferences", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), "context", new Modifier[]{Modifier.PRIVATE}).addMethod(loadMethod).addMethod(saveMethod).addMethod(CodeGenerator.generateContextConstructor()).build();
        JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)manager).build();
        file.writeTo(filer);
    }

    public static void generateGsonFileCode(Elements elementUtils, Filer filer, AnnotatedClass annotatedClass) throws IOException {
        String generatedClassName = annotatedClass.getTypeElement().getSimpleName() + SUFFIX;
        String packageName = CodeGenerator.getPackageName(elementUtils, annotatedClass);
        MethodSpec saveMethod = MethodSpec.methodBuilder((String)"save").addJavadoc("Writes object to openFileOutput().\n", new Object[0]).addParameter((TypeName)ClassName.get((String)packageName, (String)annotatedClass.getTypeElement().getSimpleName().toString(), (String[])new String[0]), "data", new Modifier[0]).addCode("try {\n\tgson = new Gson();\n\tString s = gson.toJson(data);\n\tosw = new OutputStreamWriter(context.openFileOutput(\"" + annotatedClass.getKey() + "\", Context.MODE_PRIVATE));\n" + "\tosw.write(s);\n" + "\tosw.close();\n" + "} catch(Exception e) {\n" + "\t// Empty\n" + "}\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        MethodSpec loadMethod = MethodSpec.methodBuilder((String)"load").returns((TypeName)ClassName.get((TypeElement)annotatedClass.getTypeElement())).addJavadoc("Reads object from openFileInput().\n", new Object[0]).addJavadoc("@return " + annotatedClass.getTypeElement().getSimpleName() + " In case an exception is thrown, returns {@code new " + annotatedClass.getTypeElement().getSimpleName() + "()}\n", new Object[0]).addCode("try {\n\tfis = context.openFileInput(\"" + annotatedClass.getKey() + "\");\n" + "\tbr = new BufferedReader(new InputStreamReader(fis));\n" + "\tStringBuilder sb = new StringBuilder();\n" + "\tString line;\n" + "\twhile ((line = br.readLine()) != null) {\n" + "\t\tsb.append(line);\n" + "\t}\n" + "\tString json = sb.toString();\n" + "\tObject input = gson.fromJson(json, Object.class);\n" + "\tbr.close();\n" + "\treturn (" + annotatedClass.getTypeElement().getSimpleName() + ") input;\n" + "} catch(Exception e) {\n" + "\treturn new " + annotatedClass.getTypeElement().getSimpleName() + "();\n" + "}\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).build();
        TypeSpec manager = TypeSpec.classBuilder((String)generatedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField((TypeName)ClassName.get((String)"java.io", (String)"FileInputStream", (String[])new String[0]), "fis", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"InputStreamReader", (String[])new String[0]), "ir", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"BufferedReader", (String[])new String[0]), "br", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"java.io", (String)"OutputStreamWriter", (String[])new String[0]), "osw", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), "context", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get((String)"com.google.gson", (String)"Gson", (String[])new String[0]), "gson", new Modifier[]{Modifier.PRIVATE}).addMethod(loadMethod).addMethod(saveMethod).addMethod(CodeGenerator.generateContextConstructor()).build();
        JavaFile file = JavaFile.builder((String)packageName, (TypeSpec)manager).build();
        file.writeTo(filer);
    }

    private static MethodSpec generateContextConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]), "context", new Modifier[0]).addStatement("this.$N = $N", new Object[]{"context", "context"}).build();
    }
}

