/*
 * Decompiled with CFR 0.152.
 */
package dk.nodes.data.lib;

import com.google.auto.service.AutoService;
import dk.nodes.data.annotation.Data;
import dk.nodes.data.annotation.Mode;
import dk.nodes.data.annotation.Persistence;
import dk.nodes.data.lib.AnnotatedClass;
import dk.nodes.data.lib.CodeGenerator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public class DataProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;
    private Map<String, AnnotatedClass> annotatedClasses = new HashMap<String, AnnotatedClass>();

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.typeUtils = this.processingEnv.getTypeUtils();
        this.elementUtils = this.processingEnv.getElementUtils();
        this.filer = this.processingEnv.getFiler();
        this.messager = this.processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        try {
            for (Element element : env.getElementsAnnotatedWith(Data.class)) {
                if (element.getKind() != ElementKind.CLASS) continue;
                TypeElement typeElement = (TypeElement)element;
                AnnotatedClass annotatedClass = new AnnotatedClass(typeElement);
                if (this.annotatedClasses.containsKey(typeElement.getSimpleName())) {
                    this.error(typeElement, String.format("Already contains an element %s, cant create duplicate managers.", new Object[0]));
                    return false;
                }
                this.annotatedClasses.put(typeElement.getSimpleName().toString(), annotatedClass);
            }
            for (AnnotatedClass annotatedClass : this.annotatedClasses.values()) {
                if (annotatedClass.getPersistence().equals((Object)Persistence.SERIALIZATION)) {
                    if (annotatedClass.getMode().equals((Object)Mode.FILE)) {
                        CodeGenerator.generateSerializedFileCode(this.elementUtils, this.filer, annotatedClass);
                        continue;
                    }
                    CodeGenerator.generateSerializedPrefsCode(this.elementUtils, this.filer, annotatedClass);
                    continue;
                }
                if (!annotatedClass.getPersistence().equals((Object)Persistence.GSON)) continue;
                if (annotatedClass.getMode().equals((Object)Mode.FILE)) {
                    CodeGenerator.generateGsonFileCode(this.elementUtils, this.filer, annotatedClass);
                    continue;
                }
                CodeGenerator.generateGsonPrefsCode(this.elementUtils, this.filer, annotatedClass);
            }
            this.annotatedClasses.clear();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        return true;
    }

    public void error(Element e, String msg) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotataions = new LinkedHashSet<String>();
        annotataions.add(Data.class.getCanonicalName());
        return annotataions;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

